/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.net;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nrg.net.HttpURLConnectionProcessor;

public class StringListConnectionProcessor
implements HttpURLConnectionProcessor,
Iterable<String> {
    private final List<String> items = Lists.newArrayList();

    public List<String> getStrings() {
        return this.items;
    }

    @Override
    public Iterator<String> iterator() {
        return this.items.iterator();
    }

    @Override
    public void prepare(HttpURLConnection connection) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(HttpURLConnection connection) throws IOException {
        InputStream in = connection.getInputStream();
        IOException ioexception = null;
        try {
            this.items.addAll(StringListConnectionProcessor.readStrings(in));
        }
        catch (IOException e) {
            try {
                ioexception = e;
                throw ioexception;
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    IOException iOException;
                    if (null == ioexception) {
                        iOException = e2;
                        throw iOException;
                    }
                    iOException = ioexception;
                    throw iOException;
                }
            }
        }
        try {
            in.close();
            return;
        }
        catch (IOException e) {
            IOException iOException;
            if (null == ioexception) {
                iOException = e;
                throw iOException;
            }
            iOException = ioexception;
            throw iOException;
        }
    }

    public static final List<String> readStrings(InputStream in) throws IOException {
        ArrayList items = Lists.newArrayList();
        IOException ioexception = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            Object line = reader.readLine();
            while (null != line) {
                items.add(((String)line).trim());
                line = reader.readLine();
            }
            line = items;
            return line;
        }
        catch (IOException e) {
            ioexception = e;
            throw ioexception;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                if (null == ioexception) {
                    ioexception = e;
                }
                throw ioexception;
            }
        }
    }
}

