/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.net.xnat;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.nrg.net.RestServer;
import org.nrg.net.StringListConnectionProcessor;

public final class PETTracerRetriever
implements Callable<Set<String>> {
    private static final String DEFAULT_TRACERS_RESOURCE = "/PET-tracers.txt";
    private static final Set<String> defaultTracers = PETTracerRetriever.getDefaultTracers("/PET-tracers.txt");
    private final RestServer xnat;
    private final String path;

    public PETTracerRetriever(RestServer xnat, String project) {
        this.xnat = xnat;
        this.path = "/REST/projects/" + project + "/resources/UPLOAD_CONFIG/files/PET-tracers.txt";
    }

    @Override
    public Set<String> call() {
        StringListConnectionProcessor processor = new StringListConnectionProcessor();
        try {
            this.xnat.doGet(this.path, processor);
            return Sets.newLinkedHashSet((Iterable)processor);
        }
        catch (Throwable t) {
            return PETTracerRetriever.getDefaultTracers();
        }
    }

    public static Set<String> getDefaultTracers() {
        return Sets.newLinkedHashSet(defaultTracers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getDefaultTracers(String resource) {
        IOException ioexception = null;
        InputStream in = PETTracerRetriever.class.getResourceAsStream(resource);
        if (null == in) {
            throw new RuntimeException("Unable to load default PET tracers");
        }
        try {
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSet(StringListConnectionProcessor.readStrings(in));
            return linkedHashSet;
        }
        catch (IOException e) {
            ioexception = e;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                ioexception = e;
            }
        }
        throw new RuntimeException("Unable to read default PET tracers", ioexception);
    }
}

