/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.net.xnat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.nrg.net.HttpException;
import org.nrg.net.RestServer;

public final class SeriesImportFilterApplicatorRetriever {
    private static final String SITE_WIDE_PATH = "/data/config/seriesImportFilter/config?format=json";
    private static final String PROJECT_SPECIFIC_PATH = "/data/projects/%s/config/seriesImportFilter/config?format=json";
    private final RestServer _xnat;
    private final SeriesImportFilter _siteWideFilters;
    private final SeriesImportFilter _projectFilters;
    private static final SeriesImportFilter NULL_FILTER = new SeriesImportFilter();

    public SeriesImportFilterApplicatorRetriever(RestServer xnat, String project) throws IOException, JSONException {
        this._xnat = xnat;
        this._siteWideFilters = this.extractSeriesImportFilters(SITE_WIDE_PATH);
        this._projectFilters = !StringUtils.isBlank((String)project) ? this.extractSeriesImportFilters(String.format(PROJECT_SPECIFIC_PATH, project)) : null;
    }

    public boolean checkSeries(String description) {
        return this._siteWideFilters.allow(description) && (this._projectFilters == null || this._projectFilters.allow(description));
    }

    private SeriesImportFilter extractSeriesImportFilters(String path) throws IOException, JSONException {
        try {
            Map<String, Object> keys = this._xnat.getSeriesImportFilter(path);
            return new SeriesImportFilter(keys);
        }
        catch (HttpException exception) {
            if (exception.getResponseCode() == 404) {
                return NULL_FILTER;
            }
            throw exception;
        }
    }

    static class SeriesImportFilter {
        private final boolean _enabled;
        private final String _mode;
        private final List<Pattern> _patterns = new ArrayList<Pattern>();

        private SeriesImportFilter() {
            this._enabled = false;
            this._mode = null;
        }

        public SeriesImportFilter(Map<String, Object> keys) {
            this._enabled = keys.get("status").equals("enabled");
            if (!this._enabled) {
                this._mode = "blacklist";
            } else if (keys.containsKey("contents")) {
                String rawFilters;
                Map contents = (Map)keys.get("contents");
                this._mode = contents.containsKey("mode") ? (String)contents.get("mode") : "";
                String string = rawFilters = contents.containsKey("list") ? (String)contents.get("list") : "";
                if (!StringUtils.isBlank((String)rawFilters)) {
                    String[] filters;
                    for (String filter : filters = rawFilters.trim().split("\n")) {
                        this._patterns.add(Pattern.compile(filter, 2));
                    }
                }
            } else {
                this._mode = "blacklist";
            }
        }

        public boolean allow(String seriesDescription) {
            if (!this._enabled) {
                return true;
            }
            for (Pattern pattern : this._patterns) {
                Matcher matcher = pattern.matcher(seriesDescription == null ? "" : seriesDescription);
                if (!matcher.matches()) continue;
                return this._mode.equals("whitelist");
            }
            return this._mode.equals("blacklist");
        }
    }
}

