/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.data;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Set;
import org.nrg.upload.data.SessionVariable;
import org.nrg.upload.data.ValueListener;
import org.nrg.upload.data.ValueValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionVariable
implements SessionVariable {
    private final Logger logger = LoggerFactory.getLogger(AbstractSessionVariable.class);
    private final String name;
    private final String exportField;
    private final Set<ValueListener> listeners = Sets.newLinkedHashSet();
    private final Set<ValueValidator> validators = Sets.newLinkedHashSet();
    private final Set<SessionVariable> shadows = Sets.newLinkedHashSet();
    private String description = null;
    private boolean isMutable = true;

    protected AbstractSessionVariable(String name, String exportField) {
        this.name = name;
        this.exportField = exportField;
    }

    protected AbstractSessionVariable(String name) {
        this(name, null);
    }

    @Override
    public final void addListener(ValueListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(ValueListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public final void addValidator(ValueValidator validator) {
        if (!this.validators.contains(validator)) {
            this.validators.add(validator);
        }
    }

    @Override
    public String getDescription() {
        return Strings.isNullOrEmpty((String)this.description) ? this.name : this.description;
    }

    @Override
    public String getExportField() {
        return this.exportField;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public String setDescription(String description) {
        String old = this.description;
        this.description = description;
        return old;
    }

    @Override
    public SessionVariable fixValue() {
        this.isMutable = false;
        return this;
    }

    @Override
    public SessionVariable fixValue(String value) throws SessionVariable.InvalidValueException {
        this.setValue(value);
        return this.fixValue();
    }

    @Override
    public final String validate(String value) throws SessionVariable.InvalidValueException {
        StringBuilder sb = null;
        for (ValueValidator validator : this.validators) {
            if (validator.isValid(value)) {
                String message = validator.getMessage(value);
                if (null == message) continue;
                if (null == sb) {
                    sb = new StringBuilder(message);
                    continue;
                }
                sb.append("; ").append(message);
                continue;
            }
            throw new SessionVariable.InvalidValueException(validator.getMessage(value));
        }
        return null == sb ? null : sb.toString();
    }

    public final void addShadow(SessionVariable shadow) {
        if (!this.shadows.contains(shadow)) {
            this.shadows.add(shadow);
        }
    }

    protected final void fireHasChanged() {
        String value = this.getValue();
        this.logger.trace("{} value has changed to {}", (Object)this, (Object)value);
        for (ValueListener listener : this.listeners) {
            this.logger.trace("{} notifying listener {} of value change", (Object)this, (Object)listener);
            listener.hasChanged(this);
        }
        for (SessionVariable shadow : this.shadows) {
            try {
                shadow.setValue(value);
            }
            catch (SessionVariable.InvalidValueException e) {
                this.logger.error(this + "unable to set shadow value", (Throwable)e);
            }
        }
    }

    protected final void fireIsInvalid(Object value, String message) {
        this.logger.trace("attempted to set {} to invalid value {}", (Object)this, value);
        for (ValueListener listener : this.listeners) {
            this.logger.trace("{} notifying listener {} of invalid value", (Object)this, (Object)listener);
            listener.isInvalid(this, value, message);
        }
    }
}

