/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.data;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.nrg.upload.data.ValueValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcludingValueValidator
implements ValueValidator {
    private final Logger logger = LoggerFactory.getLogger(ExcludingValueValidator.class);
    private final Set<?> excluding;
    private final String message;
    private final boolean isStrict;

    public ExcludingValueValidator(Collection<?> excluding, String message, boolean isStrict) {
        this.excluding = ImmutableSet.copyOf(excluding);
        this.message = message;
        this.isStrict = isStrict;
    }

    @Override
    public String getMessage(Object value) {
        this.logger.trace("checking for {} in {}", value, this.excluding);
        return this.excluding.contains(value) ? String.format(this.message, value) : null;
    }

    @Override
    public boolean isValid(Object value) {
        return !this.isStrict || !this.excluding.contains(value);
    }

    public boolean contains(Object value) {
        return this.excluding.contains(value);
    }
}

