/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.data;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.nrg.upload.data.ValueValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelValueValidator
implements ValueValidator {
    private static final LabelValueValidator instance = new LabelValueValidator();
    private final Logger logger = LoggerFactory.getLogger(LabelValueValidator.class);
    private static final Pattern LABEL_VALIDATOR = Pattern.compile("^[A-z0-9_]{1,64}$");

    private LabelValueValidator() {
    }

    public static LabelValueValidator getInstance() {
        return instance;
    }

    @Override
    public String getMessage(Object value) {
        if (this.isValid(value)) {
            return null;
        }
        if (null == value || "".equals(value)) {
            return "Empty label not allowed.";
        }
        return "Only numbers, letters, or _ allowed in label.";
    }

    @Override
    public boolean isValid(Object value) {
        this.logger.trace("Checking {} for validity", value);
        if (value == null) {
            return false;
        }
        String contents = value.toString();
        return !StringUtils.isBlank((String)contents) && LABEL_VALIDATOR.matcher(contents).matches();
    }
}

