/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.nrg.net.RestServer;
import org.nrg.upload.data.Project;
import org.nrg.upload.data.Subject;
import org.nrg.upload.data.SubjectInformation;
import org.nrg.upload.ui.SelectSubjectPage;
import org.nrg.upload.ui.UIUtils;
import org.nrg.xnat.Labels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewSubjectDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "Create new subject";
    private static final String CREATE_LABEL = "Create";
    private static final String CANCEL_LABEL = "Cancel";
    private static final String ID_LABEL = "Subject label:";
    private static final int VALUE_WIDTH = 24;
    private static final String EMPTY_MESSAGE = " ";
    private static final String EMPTY_LABEL_MESSAGE = "Label cannot be empty.";
    private static final String INVALID_LABEL_MESSAGE = "Label may contain only letters, digits, hyphen (-) and underscore (_).";
    private static final String EXISTING_SUBJECT_MESSAGE = "Subject %s already exists.";
    private final Logger logger = LoggerFactory.getLogger(NewSubjectDialog.class);
    private final SelectSubjectPage page;
    private final RestServer xnat;
    private final Project project;
    private JPanel contents = null;

    public NewSubjectDialog(SelectSubjectPage page, RestServer xnat, Project project) {
        super(UIUtils.findParentFrame((Component)((Object)page)), TITLE, true);
        this.setLocationRelativeTo(this.getOwner());
        this.page = page;
        this.xnat = xnat;
        this.project = project;
        this.setContentPane(this.getContents());
        this.pack();
    }

    private void doCreateSubject(final String label) {
        Callable<Subject> doCreate = new Callable<Subject>(){

            @Override
            public Subject call() throws SubjectInformation.UploadSubjectException {
                SubjectInformation subjectInfo = new SubjectInformation(NewSubjectDialog.this.xnat, NewSubjectDialog.this.project);
                subjectInfo.setLabel(label);
                try {
                    Subject subject = subjectInfo.uploadTo();
                    NewSubjectDialog.this.project.addSubject(subject);
                    NewSubjectDialog.this.page.refreshSubjectList(subject);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NewSubjectDialog.this.dispose();
                        }
                    });
                    return subject;
                }
                catch (SubjectInformation.UploadSubjectException e) {
                    NewSubjectDialog.this.logger.error("Unable to create subject " + label, (Throwable)e);
                    JOptionPane.showMessageDialog(NewSubjectDialog.this, "There was a problem uploading the new subject " + label + ": " + e.getMessage(), "Subject creation failed", 0);
                    throw e;
                }
            }
        };
        this.project.submit(doCreate);
    }

    private final JPanel getContents() {
        if (null == this.contents) {
            this.contents = new JPanel(new GridBagLayout());
            JLabel idLabel = this.makeLabel(ID_LABEL);
            final JLabel idMessage = this.makeMessage();
            final JTextField idTF = this.makeTextField();
            final JButton cancelButton = new JButton(CANCEL_LABEL);
            final JButton createButton = new JButton(CREATE_LABEL);
            idMessage.setForeground(Color.RED);
            idTF.getDocument().addDocumentListener(new DocumentListener(){

                private void handle(DocumentEvent ev) {
                    String text = idTF.getText();
                    if (Strings.isNullOrEmpty((String)text)) {
                        idMessage.setText(NewSubjectDialog.EMPTY_LABEL_MESSAGE);
                        createButton.setEnabled(false);
                    } else if (!Labels.isValidLabel((CharSequence)text)) {
                        idMessage.setText(NewSubjectDialog.INVALID_LABEL_MESSAGE);
                        createButton.setEnabled(false);
                    } else {
                        try {
                            if (NewSubjectDialog.this.project.hasSubject(text)) {
                                idMessage.setText(String.format(NewSubjectDialog.EXISTING_SUBJECT_MESSAGE, text));
                                createButton.setEnabled(false);
                            } else {
                                idMessage.setText(NewSubjectDialog.EMPTY_MESSAGE);
                                createButton.setEnabled(true);
                            }
                        }
                        catch (Throwable e) {
                            NewSubjectDialog.this.logger.error("unable to check for subject " + text + " in " + NewSubjectDialog.this.project, e);
                            idMessage.setText(NewSubjectDialog.EMPTY_MESSAGE);
                            createButton.setEnabled(true);
                        }
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handle(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handle(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handle(e);
                }
            });
            idMessage.setText(EMPTY_LABEL_MESSAGE);
            createButton.setEnabled(false);
            cancelButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent ev) {
                    NewSubjectDialog.this.dispose();
                }
            });
            createButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent ev) {
                    String label = idTF.getText();
                    if (Labels.isValidLabel((CharSequence)label)) {
                        createButton.setEnabled(false);
                        cancelButton.setEnabled(false);
                        NewSubjectDialog.this.doCreateSubject(label);
                    } else {
                        idMessage.setText(NewSubjectDialog.INVALID_LABEL_MESSAGE);
                        createButton.setEnabled(false);
                    }
                }
            });
            this.contents.add((Component)idLabel, this.makeLabelConstraints(0));
            this.contents.add((Component)idTF, this.makeValueConstraints(0));
            this.contents.add((Component)idMessage, this.makeMessageConstraints(1));
            this.contents.add((Component)cancelButton, this.makeButtonConstraints(1, 2));
            this.contents.add((Component)createButton, this.makeButtonConstraints(2, 2));
        }
        return this.contents;
    }

    private final JLabel makeLabel(String text) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(4);
        label.setHorizontalTextPosition(4);
        return label;
    }

    private final GridBagConstraints makeLabelConstraints(int row) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.insets = new Insets(4, 8, 0, 0);
        return gbc;
    }

    private final JTextField makeTextField() {
        JTextField text = new JTextField(24);
        text.setMinimumSize(text.getPreferredSize());
        return text;
    }

    private final GridBagConstraints makeValueConstraints(int row) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 2, 2, 2);
        return gbc;
    }

    private final GridBagConstraints makeButtonConstraints(int col, int row) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.insets = new Insets(2, 2, 2, 2);
        return gbc;
    }

    private final JLabel makeMessage() {
        JLabel label = new JLabel(EMPTY_MESSAGE);
        label.setFont(new Font("Dialog", 0, 10));
        label.setHorizontalAlignment(2);
        label.setHorizontalTextPosition(2);
        return label;
    }

    private final GridBagConstraints makeMessageConstraints(int row) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.gridy = row;
        return gbc;
    }
}

