/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;
import org.nrg.io.MasterTrawler;
import org.nrg.net.RestServer;
import org.nrg.net.xnat.SeriesImportFilterApplicatorRetriever;
import org.nrg.upload.data.Project;
import org.nrg.upload.data.Session;
import org.nrg.upload.ui.SelectSessionAction;
import org.nrg.upload.ui.SessionReviewPanel;
import org.nrg.upload.ui.SwingProgressMonitor;
import org.nrg.upload.ui.UIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelectSessionPage
extends WizardPage
implements SelectSessionAction.SessionSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final String PRODUCT_NAME = "*session*";
    private static final String STEP_DESCRIPTION = "Verify selected session";
    private static final String LONG_DESCRIPTION = "Review and verify selected session information";
    private SessionReviewPanel _current;
    private RestServer _xnat;
    private SeriesImportFilterApplicatorRetriever _filter = null;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private Future<List<Session>> sessionLister = null;

    public static String getDescription() {
        return STEP_DESCRIPTION;
    }

    public SelectSessionPage(RestServer xnat) throws IOException, JSONException {
        this(xnat, null);
    }

    public SelectSessionPage(RestServer xnat, String project) throws IOException, JSONException {
        this.setLayout(new BorderLayout());
        this.setLongDescription(LONG_DESCRIPTION);
        this._xnat = xnat;
        if (!StringUtils.isBlank((String)project)) {
            this._filter = new SeriesImportFilterApplicatorRetriever(xnat, project);
        }
    }

    public WizardPanelNavResult allowBack(String stepName, Map settings, Wizard wizard) {
        if (null != this.sessionLister) {
            this.sessionLister.cancel(true);
            this.sessionLister = null;
        }
        this.removeAll();
        return super.allowBack(stepName, settings, wizard);
    }

    public WizardPanelNavResult allowNext(String stepName, Map settings, Wizard wizard) {
        return this._current == null ? WizardPanelNavResult.REMAIN_ON_PAGE : WizardPanelNavResult.PROCEED;
    }

    @Override
    public void isSelected(Session session) {
        this.setProblem(null);
        this.putWizardData(PRODUCT_NAME, session);
    }

    protected void recycle() {
        this.removeAll();
        this.sessionLister = null;
    }

    protected void renderingPage() {
        if (null == this.sessionLister) {
            JFileChooser fc = (JFileChooser)this.getWizardData("*file-chooser*");
            File[] selected = fc.getSelectedFiles();
            File[] files = 0 == selected.length ? new File[]{fc.getCurrentDirectory()} : selected;
            this.sessionLister = this.executor.submit(new SessionLister((Container)((Object)this), files));
        }
    }

    protected String validateContents(Component component, Object event) {
        Session session = (Session)this.getWizardData(PRODUCT_NAME);
        if (null == session) {
            return null != this.sessionLister && this.sessionLister.isDone() ? "Select a session" : "Searching for sessions...";
        }
        if (session.getFileCount() > 0) {
            return null;
        }
        return "Directory contains no DICOM files; try another directory.";
    }

    private class SessionLister
    implements Callable<List<Session>> {
        private final Logger logger = LoggerFactory.getLogger(SessionLister.class);
        private final Container container;
        private final Collection<File> files;

        SessionLister(Container container, Collection<File> files) {
            this.container = container;
            this.files = Lists.newArrayList(files);
            this.logger.trace("initializing SessionLister from {}", files);
        }

        SessionLister(Container container, File[] files) {
            this(container, Arrays.asList(files));
        }

        @Override
        public List<Session> call() {
            if (SelectSessionPage.this._filter == null) {
                Project project = (Project)SelectSessionPage.this.getWizardData("project");
                try {
                    if (project == null) {
                        SelectSessionPage.this._filter = new SeriesImportFilterApplicatorRetriever(SelectSessionPage.this._xnat, null);
                    } else {
                        SelectSessionPage.this._filter = new SeriesImportFilterApplicatorRetriever(SelectSessionPage.this._xnat, project.toString());
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error encountered retrieving series import filters", exception);
                }
            }
            SelectSessionPage.this.setBusy(true);
            SwingProgressMonitor progress = new SwingProgressMonitor(this.container, "Finding data files", "searching", 0, this.files.size());
            Object sessions = new MasterTrawler(progress, this.files, SelectSessionPage.this._filter).call();
            try {
                SwingUtilities.invokeAndWait(new Runnable((List)sessions){
                    final /* synthetic */ List val$sessions;
                    {
                        this.val$sessions = list;
                    }

                    @Override
                    public void run() {
                        JComponent component;
                        String instructions;
                        switch (this.val$sessions.size()) {
                            case 0: {
                                instructions = null;
                                component = null;
                                break;
                            }
                            case 1: {
                                instructions = "Please confirm the scans to be included:";
                                Session single = (Session)this.val$sessions.iterator().next();
                                component = SelectSessionPage.this._current = new SessionReviewPanel(single);
                                SelectSessionPage.this.putWizardData(SelectSessionPage.PRODUCT_NAME, single);
                                break;
                            }
                            default: {
                                instructions = "Multiple sessions: Select one and confirm the scans to be included:";
                                final JSplitPane main = new JSplitPane(0);
                                final ArrayList<SessionReviewPanel> panels = new ArrayList<SessionReviewPanel>(this.val$sessions.size());
                                final JComboBox<String> comboBox = new JComboBox<String>();
                                comboBox.addItem("(Select a session to upload...)");
                                SelectSessionPage.this._current = null;
                                for (Session session : this.val$sessions) {
                                    comboBox.addItem(session.toString());
                                    panels.add(new SessionReviewPanel(session));
                                }
                                comboBox.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent event) {
                                        int index;
                                        if (SelectSessionPage.this._current == null) {
                                            index = comboBox.getSelectedIndex() - 1;
                                            comboBox.removeItemAt(0);
                                        } else {
                                            index = comboBox.getSelectedIndex();
                                        }
                                        SelectSessionPage.this._current = (SessionReviewPanel)panels.get(index);
                                        main.setBottomComponent(new JScrollPane(SelectSessionPage.this._current));
                                        SelectSessionPage.this.isSelected(SelectSessionPage.this._current.getSession());
                                    }
                                });
                                try {
                                    main.setTopComponent(comboBox);
                                    main.setBottomComponent(new JScrollPane(new JLabel(){
                                        {
                                            this.setFont(this.getFont().deriveFont(2));
                                            this.setHorizontalAlignment(2);
                                            this.setVerticalAlignment(1);
                                            this.setText("Select a session to see the details of the session and included scans.");
                                        }
                                    }));
                                }
                                catch (Exception exception) {
                                    UIUtils.handleAppletError((Component)((Object)SelectSessionPage.this), exception);
                                }
                                component = main;
                                SelectSessionPage.this.setProblem("Select a session");
                            }
                        }
                        if (null == component) {
                            SelectSessionPage.this.setProblem("No sessions available: select a different directory.");
                        } else {
                            SessionLister.this.container.add((Component)new JLabel(instructions), "First");
                            SessionLister.this.container.add((Component)component, "Center");
                            SessionLister.this.container.validate();
                        }
                        SelectSessionPage.this.setBusy(false);
                    }
                });
            }
            catch (InterruptedException exception) {
                UIUtils.handleAppletError((Component)((Object)SelectSessionPage.this), exception);
            }
            catch (InvocationTargetException exception) {
                UIUtils.handleAppletError((Component)((Object)SelectSessionPage.this), exception);
            }
            SelectSessionPage.this.setBusy(false);
            return sessions;
        }
    }
}

