/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import com.google.common.base.Joiner;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.nrg.dcm.Series;
import org.nrg.dcm.Study;
import org.nrg.upload.data.Session;
import org.nrg.util.Utils;

public final class SessionReviewPanel
extends JPanel {
    public static final int MAX_TAG = Collections.max(new ArrayList<Integer>(){
        {
            this.add(528446);
            this.add(0x200011);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Session _session;

    public SessionReviewPanel(Session session) {
        this.setLayout(new BoxLayout(this, 3));
        this._session = session;
        if (session instanceof Study) {
            this.add(SessionReviewPanel.createScanDetails(session));
        }
        this.add(SessionReviewPanel.createSessionSummary(session));
        this.setVisible(true);
    }

    private static JPanel createScanDetails(Session session) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(new JLabel("<html><b>Scan Details</b></html>"));
        panel.add(SessionReviewPanel.buildScansTable((Study)session));
        panel.add(new JLabel("Note: Unchecked scans will not be uploaded."));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        return panel;
    }

    private static JPanel createSessionSummary(Session session) {
        Date sessionDate = session.getDateTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (session.getTimeZone() != null) {
            sdf.setTimeZone(session.getTimeZone());
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(new JLabel("<html><b>Session Summary</b></html>"));
        panel.add(new JLabel(session.getFormat() + " _session " + session.getID()));
        panel.add(new JLabel("Accession: " + session.getAccession()));
        panel.add(new JLabel("Description: " + session.getDescription()));
        if (sessionDate != null) {
            panel.add(new JLabel("Date: " + sdf.format(sessionDate)));
        } else {
            panel.add(new JLabel("Date: Unknown"));
        }
        panel.add(SessionReviewPanel.buildModalitiesLabel(session));
        panel.add(new JLabel(SessionReviewPanel.describeScans(session)));
        return panel;
    }

    private static JLabel buildModalitiesLabel(Session session) {
        Set<String> modalities = session.getModalities();
        if (1 == modalities.size()) {
            return new JLabel("Modality: " + modalities.iterator().next());
        }
        Joiner joiner = Joiner.on((char)',');
        StringBuilder sb = new StringBuilder("Modalities: ");
        joiner.appendTo(sb, modalities);
        return new JLabel(sb.toString());
    }

    private static JScrollPane buildScansTable(Study study) {
        ScansTableModel tableModel = new ScansTableModel(study);
        JTable table = new JTable(tableModel);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(table.getModel());
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        table.setRowSorter(sorter);
        table.setIntercellSpacing(new Dimension(10, 0));
        JScrollPane scrollPane = new JScrollPane(table);
        int width = table.getPreferredSize().width;
        int height = table.getRowCount() * table.getRowHeight();
        table.getColumnModel().getColumn(0).setPreferredWidth(20);
        table.getColumnModel().getColumn(1).setPreferredWidth(20);
        table.getColumnModel().getColumn(2).setPreferredWidth(width - 120);
        table.getColumnModel().getColumn(3).setPreferredWidth(40);
        table.getColumnModel().getColumn(4).setPreferredWidth(40);
        table.setPreferredScrollableViewportSize(new Dimension(width, height));
        return scrollPane;
    }

    public Session getSession() {
        return this._session;
    }

    public static String describeScans(Session session) {
        StringBuilder sb = new StringBuilder();
        int scans = session.getScanCount();
        sb.append(scans).append(1 == scans ? " scan in " : " scans in ");
        int files = session.getFileCount();
        sb.append(files).append(1 == files ? " file" : " files");
        sb.append(" (");
        Utils.showNearestUnits(sb, session.getSize(), "B");
        sb.append(")");
        return sb.toString();
    }

    static class ScansTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 3558061608731992249L;
        private static final int SELECT_COLUMN = 0;
        private static final String[] COLUMNS = new String[]{"Upload", "#", "Scan Type", "File Count", "Size (bytes)"};
        private static final Class<?>[] COLUMN_TYPES = new Class[]{Boolean.class, Integer.class, String.class, Integer.class, Long.class};

        public ScansTableModel(Study study) {
            super(COLUMNS, 0);
            final ArrayList<Series> seriesList = new ArrayList<Series>();
            for (Series series : study.getSeries()) {
                seriesList.add(series);
                String description = series.getSampleObject().getString(528446);
                if (description == null) {
                    description = "<Empty series description>";
                }
                this.addRow(new Object[]{series.isUploadAllowed(), series.get(0x200011), description, series.getFileCount(), Utils.showNearestUnits(new StringBuilder(), series.getSize(), "B").toString()});
            }
            this.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    int row = e.getFirstRow();
                    ((Series)seriesList.get(row)).setUploadAllowed((Boolean)ScansTableModel.this.getValueAt(row, 0));
                }
            });
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return COLUMN_TYPES[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    }
}

