/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.awt.Component;
import java.util.Collection;
import java.util.Map;
import javax.swing.JOptionPane;
import org.nrg.upload.data.UploadFailureHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingUploadFailureHandler
implements UploadFailureHandler {
    private static final int DEFAULT_MAX_TRIES = 3;
    public static final String DIALOG_NAME = "Upload error";
    private static final Object[] DIALOG_OPTIONS = new Object[]{"Try again", "Stop uploading this session"};
    private static final Object DEFAULT_DIALOG_OPTION = DIALOG_OPTIONS[0];
    private static final Map<Integer, Boolean> actions = ImmutableMap.of((Object)0, (Object)true, (Object)1, (Object)false);
    private static final String NL = System.getProperty("line.separator");
    private final Logger logger = LoggerFactory.getLogger(SwingUploadFailureHandler.class);
    private final Component parent;
    private final int maxTries;
    private final Multimap<Object, Object> failures = LinkedListMultimap.create();
    private final Map<Class<? extends Throwable>, Throwable> throwables = Maps.newLinkedHashMap();

    SwingUploadFailureHandler(Component parent, int maxTries) {
        this.parent = parent;
        this.maxTries = maxTries;
    }

    SwingUploadFailureHandler(Component parent) {
        this(parent, 3);
    }

    SwingUploadFailureHandler() {
        this(null, 3);
    }

    @Override
    public boolean shouldRetry(Object item, Object cause) {
        if (this.failures.size() < this.maxTries) {
            this.insertFailure(item, cause);
            return true;
        }
        StringBuilder message = new StringBuilder();
        message.append("There was a problem uploading ").append(item);
        message.append(NL).append("(").append(cause).append(")");
        message.append(NL).append("and we've already tried a total of ");
        message.append(this.maxTries).append(" resend");
        if (this.failures.size() != 1) {
            message.append("s");
        }
        message.append(":").append(NL);
        this.appendFailuresDescription(message, this.failures);
        message.append("Should we try resending ").append(item);
        message.append("?");
        this.insertFailure(item, cause);
        return actions.get(JOptionPane.showOptionDialog(this.parent, message, DIALOG_NAME, 0, 0, null, DIALOG_OPTIONS, DEFAULT_DIALOG_OPTION));
    }

    private void insertFailure(Object item, Object cause) {
        if (cause instanceof Throwable) {
            Throwable t = (Throwable)cause;
            Class<?> tclass = t.getClass();
            this.failures.put(tclass, item);
            this.throwables.put(tclass, t);
            this.logger.debug("unable to upload " + item, t);
        } else {
            this.logger.debug("unable to upload {}: {}", item, cause);
            this.failures.put(cause, item);
        }
    }

    private StringBuilder appendFailuresDescription(StringBuilder sb, Multimap<Object, ?> failures) {
        for (Object cause : failures.keySet()) {
            if (cause instanceof Class) {
                Class clazz = (Class)cause;
                sb.append(clazz.getSimpleName());
                Throwable instance = this.throwables.get(clazz);
                sb.append(" (").append(instance.getLocalizedMessage());
            } else {
                sb.append(cause);
            }
            sb.append(": ");
            Collection objects = failures.get(cause);
            switch (objects.size()) {
                case 1: {
                    sb.append(objects.iterator().next());
                    break;
                }
                default: {
                    sb.append(objects.size()).append(" items, including ");
                    sb.append(objects.iterator().next());
                }
            }
            sb.append(NL);
        }
        return sb;
    }

    public final String getButtonTextFor(boolean shouldRetry) {
        return DIALOG_OPTIONS[shouldRetry ? 0 : 1].toString();
    }
}

