/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIUtils {
    public static final String DEFAULT_DATE_FORMAT = "d MMM yyyy";
    private static final Logger _log = LoggerFactory.getLogger(UIUtils.class);

    private UIUtils() {
    }

    public static Frame findParentFrame(Component component) {
        for (Component c = component; null != c; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    public static void handleAppletError(Component component, Throwable throwable) {
        String message = throwable.getMessage();
        String formattedMessage = StringUtils.isBlank((String)message) ? "" : message + "\n";
        UIUtils.handleAppletError(component, "Found exception of type: " + throwable.getClass().getName() + "\n" + formattedMessage + UIUtils.formatStackTrace(throwable.getStackTrace()));
    }

    public static void handleAppletError(Component component, String message) {
        UIUtils.handleAppletError(component, message, "Error", 0);
    }

    public static void handleAppletError(Component component, String message, String title, int messageType) {
        Logger log;
        if (component != null) {
            if (StringUtils.isBlank((String)title)) {
                title = "Error";
            }
            JOptionPane.showMessageDialog(component, message, title, messageType);
            log = LoggerFactory.getLogger(component.getClass());
        } else {
            log = _log;
        }
        log.error(message);
    }

    public static String handleAppletInput(Component component, String message, String title, int messageType, String defaultValue) {
        return (String)JOptionPane.showInputDialog(component, message, title, messageType, null, null, defaultValue);
    }

    public static String formatStackTrace(StackTraceElement[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (StackTraceElement element : elements) {
            buffer.append(element.toString()).append("\n");
        }
        return buffer.toString();
    }

    public static boolean getConfirmSessionDatePage() {
        return Boolean.parseBoolean(System.getProperty("verification.date.display", "true"));
    }
}

