/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JApplet;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.api.wizard.WizardResultReceiver;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.nrg.net.JSESSIONIDCookie;
import org.nrg.net.RestServer;
import org.nrg.net.SwingAuthenticator;
import org.nrg.upload.data.AssignedSessionVariable;
import org.nrg.upload.data.Project;
import org.nrg.upload.data.Subject;
import org.nrg.upload.ui.AssignSessionVariablesPage;
import org.nrg.upload.ui.ConfirmSessionDatePage;
import org.nrg.upload.ui.SelectFilesPage;
import org.nrg.upload.ui.SelectProjectPage;
import org.nrg.upload.ui.SelectSessionPage;
import org.nrg.upload.ui.SelectSubjectPage;
import org.nrg.upload.ui.UIUtils;
import org.nrg.upload.ui.UploadResultPanel;
import org.nrg.upload.ui.UploadWizardResultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadAssistantApplet
extends JApplet
implements WizardResultReceiver {
    public static final String XNAT_REST_API_WIZ_PARAM = "*xnat-rest-server*";
    public static final String XNAT_URL_WIZ_PARAM = "*xnat-url*";
    public static final String XNAT_ADMIN_EMAIL_WIZ_PARAM = "*xnat-admin-email*";
    public static final String FIXED_SIZE_STREAMING_WIZ_PARAM = "*fixed-size-streaming*";
    public static final String N_UPLOAD_THREADS_WIZ_PARAM = "*n-upload-threads*";
    private final transient ActionListener closeHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UploadAssistantApplet.this.getAppletContext().showDocument(new URL(UploadAssistantApplet.this.getParameter(UploadAssistantApplet.XNAT_URL)));
            }
            catch (MalformedURLException mue) {
                UploadAssistantApplet.this.exit();
            }
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(UploadAssistantApplet.class);
    public static final String EXPECTED_MODALITY_LABEL = "*expected-modality*";
    private static final String XNAT_PROJECT = "xnat-project";
    private static final String XNAT_SUBJECT = "xnat-subject";
    private static final String XNAT_SCAN_DATE = "xnat-scan-date";
    private static final String XNAT_VISIT_ID = "xnat-visit-id";
    private static final String XNAT_VISIT = "xnat-visit";
    private static final String XNAT_PROTOCOL = "xnat-protocol";
    private static final String EXPECTED_MODALITY = "expected-modality";
    private static final String XNAT_SCAN_TYPE = "xnat-scan-type";
    private static final String XNAT_SESSION = "xnat-session-label";
    private static final String XNAT_URL = "xnat-url";
    private static final String XNAT_DESCRIPTION = "xnat-description";
    private static final String XNAT_ADMIN_EMAIL = "xnat-admin-email";
    private static final String LOG4J_PROPS_URL = "log4j-properties-url";
    private static final String CUSTOM_PROPS_URL = "custom-properties-url";
    private static final String ENABLE_REMOTE_LOGGING = "enable-remote-logging";
    private static final String REMOTE_LOGGING_PATH = "remote-logging-path";
    private static final String USE_FIXED_SIZE_STREAMING = "fixed-size-streaming";
    private static final String N_UPLOAD_THREADS = "n-upload-threads";
    private static final String WINDOW_NAME = "window-name";
    private static final String JSESSIONID = "jsessionid";
    private static final String AUTHORS = "Author: Kevin A. Archie <karchie@wustl.edu>";
    private static final String COPYRIGHT = String.format("Copyright (c) 2008-%d Washington University", Calendar.getInstance().get(1));
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String APPLET_INFO = Joiner.on((String)LINE_SEPARATOR).join((Object)"Author: Kevin A. Archie <karchie@wustl.edu>", (Object)COPYRIGHT, new Object[0]);
    private static final String DEV_USER = "dev-user";
    private static final String DEV_PASS = "dev-pass";
    private static final DateFormat PARSER_SQL = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat PARSER_CAL = new SimpleDateFormat("MM/dd/yyyy HH:mm");
    private static final String[][] PARAMETER_INFO = new String[][]{{"xnat-url", "URL", "Base URL for XNAT instance"}, {"xnat-description", "string", "Human-readable name of the XNAT instance"}, {"xnat-admin-email", "email address", "Email address for the XNAT administrator"}, {"warn-on-dupe-session-labels", "boolean", "Indicates whether the applet should warn when session labels are specified that are duplicates of existing session labels in the target project; defaults to true."}, {"allow-overwrite-on-dupe-session-labels", "boolean", "Indicates whether the applet should allow the user to select the overwrite option when session labels are specified that are duplicates of existing session labels in the target project; defaults to false."}, {"fixed-size-streaming", "boolean", "Should the applet use fixed-size streaming for data upload?"}, {"n-upload-threads", "integer", "Number of threads to use for uploading"}, {"log4j-properties-url", "URL", "URL for log4j properties file"}, {"custom-properties-url", "URL", "URL for custom properties file"}, {"enable-remote-logging", "boolean", "Indicates whether the applet should use remote logging"}, {"remote-logging-path", "string", "Path to the REST service on the remote server to handle logging"}, {"xnat-project", "string", "Indicates the project to which the uploaded resource should be added"}, {"xnat-subject", "string", "Indicates the subject to which the uploaded resource should be added"}, {"xnat-scan-date", "string", "Indicates the date the scan to be uploaded was acquired"}, {"xnat-visit-id", "string", "The visit ID to use"}, {"xnat-visit", "string", "The visit label for an existing pVisitData to which you would like to add these images"}, {"xnat-protocol", "string", "The protocol label for an experiment to differentiate identical XSI types within the same pVisitData"}, {"expected-modality", "string", "The modality you expect to upload. A warning message will appear if the image's modality doesn't match this string"}, {"xnat-scan-type", "string", "The type of scan to be uploaded"}, {"window-name", "string", "The name of the window running the applet. Defaults to applet."}, {"jsessionid", "string", "The JSESSIONID to authenticate the REST calls"}};

    public UploadAssistantApplet() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void init() {
        Authenticator authenticator;
        logger.trace("INIT {}", (Object)this);
        HttpURLConnection.setFollowRedirects(false);
        this.configureLookAndFeel();
        this.configureLogging();
        Properties properties = new Properties(System.getProperties());
        this.loadAppletProperties(properties);
        this.loadCustomProperties(properties);
        System.setProperties(properties);
        String user = this.getParameter(DEV_USER);
        String pass = this.getParameter(DEV_PASS);
        if (!StringUtils.isBlank((String)user) && !StringUtils.isBlank((String)pass)) {
            logger.warn("Using DevAuthenticator for applet credentials");
            authenticator = new DevAuthenticator(user, pass);
        } else {
            authenticator = new SwingAuthenticator(this);
        }
        Authenticator.setDefault(authenticator);
    }

    @Override
    public String getAppletInfo() {
        return APPLET_INFO;
    }

    @Override
    public String[][] getParameterInfo() {
        return PARAMETER_INFO;
    }

    @Override
    public void start() {
        logger.trace("START {}", (Object)this);
        RestServer xnat = this.initializeRestServer();
        if (xnat == null) {
            return;
        }
        Dimension dimension = new Dimension(300, 300);
        try {
            String allowOverwriteOnDupeSessionLabels;
            String warnOnDupeSessionLabels;
            String sessionLabel;
            String expectedModality;
            String protocolLabel;
            String projectName;
            logger.trace("{} initializing pages", (Object)this);
            ArrayList pages = Lists.newArrayList();
            Map<String, Object> params = this.buildParamsMap(xnat);
            String userAuthMessage = xnat.getUserAuthMessage();
            if (logger.isDebugEnabled()) {
                logger.debug("Received user auth message: " + userAuthMessage);
            }
            if (!Strings.isNullOrEmpty((String)(projectName = this.getParameter(XNAT_PROJECT)))) {
                logger.trace("project: {}", (Object)projectName);
                params.put("project", new Project(projectName, xnat, params));
            } else {
                pages.add(new SelectProjectPage(xnat, dimension));
                logger.trace("project");
            }
            String subjectName = this.getParameter(XNAT_SUBJECT);
            if (!Strings.isNullOrEmpty((String)subjectName)) {
                Project project = (Project)params.get("project");
                if (null == project) {
                    throw new UnsupportedOperationException("can't assign subject without project");
                }
                for (Subject subject : project.getSubjects()) {
                    if (!subjectName.equals(subject.getLabel()) && !subjectName.equals(subject.getId())) continue;
                    params.put("subject", subject);
                    break;
                }
            }
            if (null == params.get("subject")) {
                pages.add(new SelectSubjectPage(xnat, dimension));
            }
            logger.trace("subject");
            String visitLabel = this.getParameter(XNAT_VISIT);
            if (!Strings.isNullOrEmpty((String)visitLabel)) {
                logger.trace("visit: {}", (Object)visitLabel);
                params.put("*visit*", new AssignedSessionVariable("*visit*", visitLabel));
            }
            if (!Strings.isNullOrEmpty((String)(protocolLabel = this.getParameter(XNAT_PROTOCOL)))) {
                logger.trace("protocol: {}", (Object)protocolLabel);
                params.put("*protocol*", new AssignedSessionVariable("*protocol*", protocolLabel));
            }
            if (!Strings.isNullOrEmpty((String)(expectedModality = this.getParameter(EXPECTED_MODALITY)))) {
                logger.trace("expected modality: {}", (Object)expectedModality);
                params.put(EXPECTED_MODALITY_LABEL, expectedModality);
            }
            if (!Strings.isNullOrEmpty((String)(sessionLabel = this.getParameter(XNAT_SESSION)))) {
                logger.trace("session: {}", (Object)sessionLabel);
                params.put("predef-session", new AssignedSessionVariable("session", sessionLabel));
            }
            if (!Strings.isNullOrEmpty((String)(warnOnDupeSessionLabels = this.getParameter("warn-on-dupe-session-labels")))) {
                logger.trace("Warn on dupe session labels: {}", (Object)warnOnDupeSessionLabels);
                params.put("warn-on-dupe-session-labels", new AssignedSessionVariable("warn-on-dupe-session-labels", warnOnDupeSessionLabels));
            }
            if (!Strings.isNullOrEmpty((String)(allowOverwriteOnDupeSessionLabels = this.getParameter("allow-overwrite-on-dupe-session-labels")))) {
                logger.trace("Allow overwrite on dupe session labels: {}", (Object)allowOverwriteOnDupeSessionLabels);
                params.put("allow-overwrite-on-dupe-session-labels", new AssignedSessionVariable("allow-overwrite-on-dupe-session-labels", allowOverwriteOnDupeSessionLabels));
            }
            String scanDate = this.getParameter(XNAT_SCAN_DATE);
            if (UIUtils.getConfirmSessionDatePage()) {
                if ("no_session_date".equals(scanDate)) {
                    params.put("*session-date*", "no_session_date");
                } else {
                    Date date = this.safeParse(scanDate);
                    if (date == null) {
                        pages.add(new ConfirmSessionDatePage());
                        logger.trace("confirm date");
                    } else {
                        params.put("*session-date*", date);
                    }
                }
            }
            pages.add(new SelectFilesPage());
            logger.trace("files");
            if (StringUtils.isBlank((String)projectName)) {
                pages.add(new SelectSessionPage(xnat));
            } else {
                pages.add(new SelectSessionPage(xnat, projectName));
            }
            logger.trace("session");
            pages.add(new AssignSessionVariablesPage());
            logger.trace("session variables");
            logger.trace("{} creating wizard", (Object)this);
            Wizard wizard = WizardPage.createWizard((WizardPage[])pages.toArray(new WizardPage[pages.size()]), (WizardPage.WizardResultProducer)new UploadWizardResultProducer(Executors.newCachedThreadPool()));
            logger.trace("{} installing displayer", (Object)this);
            WizardDisplayer displayer = WizardDisplayer.installInContainer((Container)this, null, (Wizard)wizard, null, params, (WizardResultReceiver)this);
            displayer.setCloseHandler(this.closeHandler);
        }
        catch (Throwable t) {
            logger.error("wizard installation failed", t);
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            writer.println("Applet startup failed; please contact " + this.getParameter(XNAT_ADMIN_EMAIL) + " for help.");
            writer.println("Error details:");
            t.printStackTrace(writer);
            JTextArea text = new JTextArea(sw.toString());
            text.setEditable(false);
            this.add(text);
            this.validate();
        }
        logger.trace("{} setting JavaScript context", (Object)this);
        UploadResultPanel.setJSContext(this.getJSContext());
        String windowName = this.getParameter(WINDOW_NAME);
        if (!Strings.isNullOrEmpty((String)windowName)) {
            logger.trace("Setting window name: {}", (Object)windowName);
            UploadResultPanel.setWindowName(windowName);
        }
        logger.trace("{} ready", (Object)this);
    }

    @Override
    public void stop() {
        logger.trace("STOP {}", (Object)this);
    }

    public void cancelled(Map arg0) {
        try {
            this.getAppletContext().showDocument(new URL(this.getParameter(XNAT_URL)));
        }
        catch (MalformedURLException mue) {
            this.exit();
        }
    }

    public void finished(Object arg0) {
    }

    private RestServer initializeRestServer() {
        RestServer xnat = null;
        try {
            String xnatUrl = this.getParameter(XNAT_URL);
            xnat = new RestServer(xnatUrl, new JSESSIONIDCookie(this.getParameter(JSESSIONID)));
            logger.info("Started applet running with REST services at: " + xnatUrl);
        }
        catch (Throwable t) {
            logger.error("applet startup failed", t);
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            writer.println("Applet startup failed; please contact " + this.getParameter(XNAT_ADMIN_EMAIL) + " for help.");
            writer.println("Error details: " + t.getMessage());
            t.printStackTrace(writer);
            JTextArea text = new JTextArea(sw.toString());
            text.setEditable(false);
            this.add(text);
            this.validate();
        }
        return xnat;
    }

    private void configureLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Date safeParse(String scanDate) {
        if (StringUtils.isBlank((String)scanDate)) {
            return null;
        }
        try {
            return PARSER_CAL.parse(scanDate);
        }
        catch (ParseException e) {
            try {
                return PARSER_SQL.parse(scanDate);
            }
            catch (ParseException e1) {
                return null;
            }
        }
    }

    private void configureLogging() {
        String log4jProps = this.getParameter(LOG4J_PROPS_URL);
        if (null != log4jProps) {
            try {
                PropertyConfigurator.configure((URL)new URL(log4jProps));
            }
            catch (MalformedURLException e) {
                logger.error("Unable to read remote log4j configuration file " + log4jProps, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAppletProperties(Properties properties) {
        InputStream appletProperties = null;
        try {
            appletProperties = this.getClass().getResourceAsStream("/applet.properties");
            if (appletProperties != null) {
                properties.load(appletProperties);
            }
        }
        catch (IOException exception) {
            logger.info("Unable to find the applet.properties resource for initialization", (Throwable)exception);
        }
        finally {
            if (appletProperties != null) {
                try {
                    appletProperties.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomProperties(Properties properties) {
        String customProps = this.getParameter(CUSTOM_PROPS_URL);
        if (customProps != null && customProps.length() > 0) {
            InputStream customProperties = null;
            try {
                customProperties = this.getClass().getResourceAsStream(customProps);
                properties.load(customProperties);
            }
            catch (IOException exception) {
                logger.info("Unable to find the custom properties resource " + customProps + " for initialization", (Throwable)exception);
            }
            finally {
                if (customProperties != null) {
                    try {
                        customProperties.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private Map<String, Object> buildParamsMap(RestServer xnat) {
        LinkedHashMap params = Maps.newLinkedHashMap();
        params.put(XNAT_REST_API_WIZ_PARAM, xnat);
        params.put(XNAT_URL_WIZ_PARAM, xnat.getURL());
        params.put(XNAT_ADMIN_EMAIL_WIZ_PARAM, this.getParameter(XNAT_ADMIN_EMAIL));
        params.put(FIXED_SIZE_STREAMING_WIZ_PARAM, Boolean.valueOf(this.getParameter(USE_FIXED_SIZE_STREAMING, "false")));
        params.put(N_UPLOAD_THREADS_WIZ_PARAM, Integer.valueOf(this.getParameter(N_UPLOAD_THREADS, "1")));
        return params;
    }

    private JSObject getJSContext() {
        Callable<JSObject> getWindow = new Callable<JSObject>(){

            @Override
            public JSObject call() throws JSException {
                return JSObject.getWindow((Applet)UploadAssistantApplet.this);
            }
        };
        ExecutorService es = Executors.newSingleThreadExecutor();
        try {
            return (JSObject)es.invokeAny(Collections.singleton(getWindow), 10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.warn("Unable to retrieve JavaScript window context, possibly running in non-browser-hosted mode like appletviewer?");
            return null;
        }
    }

    private void exit() {
        JSObject context = this.getJSContext();
        if (null == context) {
            System.err.println("javascript close failed");
        } else {
            context.call("close", null);
        }
    }

    private String getParameter(String key, String defaultValue) {
        String v = this.getParameter(key);
        return null == v ? defaultValue : v;
    }

    private class DevAuthenticator
    extends Authenticator {
        private final String _user;
        private final String _pass;

        public DevAuthenticator(String user, String pass) {
            this._user = user;
            this._pass = pass;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this._user, this._pass.toCharArray());
        }
    }
}

