/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.upload.ui;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import org.nrg.upload.data.SessionVariable;
import org.nrg.upload.data.SessionVariableConsumer;
import org.nrg.upload.data.ValueListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VariableAssignmentManager {
    private static final String MESSAGE_SPACE = "                ";
    private static final String MESSAGE_INVALID = "INVALID";
    public static final GridBagConstraints labelConstraint = new GridBagConstraints();
    public static final GridBagConstraints valueConstraint = new GridBagConstraints();
    public static final GridBagConstraints messageConstraint = new GridBagConstraints();
    private static final Logger logger;
    private final List<VariableRow> vms;

    public VariableAssignmentManager(Container container, Collection<SessionVariable> vars, SessionVariableConsumer consumer) {
        this.vms = Lists.newArrayListWithExpectedSize((int)vars.size());
        for (SessionVariable v : vars) {
            this.vms.add(new VariableRow(v, container, consumer));
        }
        logger.trace("managing variables {}", vars);
    }

    static {
        VariableAssignmentManager.labelConstraint.gridx = 0;
        VariableAssignmentManager.labelConstraint.weightx = 0.1;
        VariableAssignmentManager.valueConstraint.gridx = 1;
        VariableAssignmentManager.valueConstraint.fill = 2;
        VariableAssignmentManager.valueConstraint.weightx = 0.6;
        VariableAssignmentManager.messageConstraint.gridx = 2;
        VariableAssignmentManager.messageConstraint.fill = 2;
        VariableAssignmentManager.messageConstraint.weightx = 0.3;
        logger = LoggerFactory.getLogger(VariableAssignmentManager.class);
    }

    private final class VariableRow
    implements ValueListener {
        private final Logger logger = LoggerFactory.getLogger(VariableRow.class);
        private final SessionVariable v;
        private final SessionVariableConsumer consumer;
        private final JLabel message;

        VariableRow(SessionVariable v, Container gbc, SessionVariableConsumer consumer) {
            this.v = v;
            this.consumer = consumer;
            this.message = new JLabel(VariableAssignmentManager.MESSAGE_SPACE);
            if (!v.isHidden()) {
                gbc.add((Component)new JLabel(v.getDescription()), labelConstraint);
                gbc.add(v.isMutable() ? v.getEditor() : new JLabel(v.getValue()), valueConstraint);
                gbc.add((Component)this.message, messageConstraint);
            }
            v.addListener(this);
            v.refresh();
            try {
                v.validate(v.getValue());
                consumer.update(v, true);
            }
            catch (SessionVariable.InvalidValueException e) {
                consumer.update(v, false);
            }
        }

        @Override
        public void hasChanged(SessionVariable v) {
            this.logger.trace("{} has changed", (Object)v);
            assert (this.v.getName().equals(v.getName()));
            this.message.setText(null);
            this.message.setToolTipText(null);
            Container parent = this.message.getParent();
            if (null != parent) {
                parent.validate();
            }
            this.consumer.update(v, true);
            Iterator vi = VariableAssignmentManager.this.vms.iterator();
            while (vi.hasNext() && !this.equals(vi.next())) {
            }
            while (vi.hasNext()) {
                ((VariableRow)vi.next()).v.refresh();
            }
        }

        @Override
        public void isInvalid(SessionVariable variable, Object value, String message) {
            this.consumer.update(this.v, false);
            this.message.setText(VariableAssignmentManager.MESSAGE_INVALID);
            this.message.setForeground(Color.RED);
            this.message.setToolTipText(message);
            this.message.getParent().validate();
        }
    }
}

