/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.orm.hibernate;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Restrictions;
import org.nrg.framework.orm.hibernate.AbstractParameterizedWorker;
import org.nrg.framework.orm.hibernate.BaseHibernateDAO;
import org.nrg.framework.orm.hibernate.BaseHibernateEntity;
import org.nrg.framework.orm.hibernate.HibernateUtils;

public abstract class AbstractHibernateDAO<E extends BaseHibernateEntity>
extends AbstractParameterizedWorker<E>
implements BaseHibernateDAO<E> {
    private static final Log _log = LogFactory.getLog(AbstractHibernateDAO.class);
    @Inject
    private SessionFactory _factory;
    private boolean _isAuditable;

    protected AbstractHibernateDAO() {
        this._isAuditable = HibernateUtils.isAuditable(this.getParameterizedType());
    }

    protected AbstractHibernateDAO(Class<E> clazz) {
        super(clazz);
        this._isAuditable = HibernateUtils.isAuditable(this.getParameterizedType());
    }

    protected AbstractHibernateDAO(SessionFactory factory) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding session factory in constructor: " + factory.hashCode()));
        }
        this._factory = factory;
    }

    @Override
    public void setSessionFactory(SessionFactory factory) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Setting session factory in setter: " + factory.hashCode()));
        }
        this._factory = factory;
    }

    @Override
    public Serializable create(E entity) {
        Date now = new Date();
        entity.setCreated(now);
        entity.setTimestamp(now);
        entity.setEnabled(true);
        entity.setDisabled(new Date(0L));
        return this.getSession().save(entity);
    }

    @Override
    public E retrieve(long id) {
        if (this._isAuditable) {
            return this.findEnabledById(id);
        }
        return (E)((BaseHibernateEntity)this.getSession().get(this.getParameterizedType(), (Serializable)Long.valueOf(id)));
    }

    @Override
    public void update(E entity) {
        entity.setTimestamp(new Date());
        this.getSession().update(entity);
    }

    @Override
    public void delete(E entity) {
        if (this._isAuditable) {
            entity.setEnabled(false);
            entity.setDisabled(new Date());
            this.getSession().update(entity);
        } else {
            this.getSession().delete(entity);
        }
    }

    @Override
    public List<E> findAll() {
        return this.findByCriteria(new Criterion[0]);
    }

    @Override
    public List<E> findAllEnabled() {
        Criteria criteria = this.getCriteriaForType();
        criteria.add((Criterion)Restrictions.eq((String)"enabled", (Object)true));
        return criteria.list();
    }

    @Override
    public List<E> findByExample(E exampleInstance, String[] excludeProperty) {
        Criteria criteria = this.getCriteriaForType();
        Example example = Example.create(exampleInstance);
        for (String exclude : excludeProperty) {
            example.excludeProperty(exclude);
        }
        criteria.add((Criterion)example);
        return criteria.list();
    }

    @Override
    public E findById(long id) {
        return this.findById(id, false);
    }

    @Override
    public E findById(long id, boolean lock) {
        BaseHibernateEntity entity = lock ? (BaseHibernateEntity)this.getSession().load(this.getParameterizedType(), (Serializable)Long.valueOf(id), LockOptions.UPGRADE) : (BaseHibernateEntity)this.getSession().load(this.getParameterizedType(), (Serializable)Long.valueOf(id));
        return (E)entity;
    }

    @Override
    public E findEnabledById(long id) {
        return this.findEnabledById(id, false);
    }

    @Override
    public E findEnabledById(long id, boolean lock) {
        E entity = this.findById(id, lock);
        return entity != null && entity.isEnabled() ? (E)entity : null;
    }

    @Override
    public void refresh(boolean initialize, E entity) {
        this.getSession().refresh(entity);
        if (initialize) {
            Hibernate.initialize(entity);
        }
    }

    protected Session getSession() {
        try {
            return this._factory.getCurrentSession();
        }
        catch (HibernateException exception) {
            _log.error((Object)("Trying to get session for parameterized type: " + this.getParameterizedType()), (Throwable)exception);
            throw exception;
        }
    }

    protected List<E> findByCriteria(Criterion ... criterion) {
        Criteria criteria = this.getCriteriaForType();
        for (Criterion c : criterion) {
            criteria.add(c);
        }
        return criteria.list();
    }

    protected Criteria getCriteriaForType() {
        Criteria criteria = this.getSession().createCriteria(this.getParameterizedType());
        criteria.setCacheable(true);
        criteria.setCacheRegion(this.getCacheRegion());
        return criteria;
    }

    protected void addNullableCriteria(Criteria c, String name, Object value) {
        if (value == null) {
            c.add(Restrictions.isNull((String)name));
        } else {
            c.add((Criterion)Restrictions.eq((String)name, (Object)value));
        }
    }
}

