/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.orm.hibernate;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nrg.framework.orm.hibernate.AbstractParameterizedWorker;
import org.nrg.framework.orm.hibernate.BaseHibernateDAO;
import org.nrg.framework.orm.hibernate.BaseHibernateEntity;
import org.nrg.framework.orm.hibernate.BaseHibernateService;
import org.nrg.framework.orm.hibernate.HibernateUtils;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractHibernateEntityService<E extends BaseHibernateEntity>
extends AbstractParameterizedWorker<E>
implements BaseHibernateService<E> {
    private static final Log _log = LogFactory.getLog(AbstractHibernateEntityService.class);
    private boolean _isAuditable = HibernateUtils.isAuditable(this.getParameterizedType());

    @Override
    public abstract E newEntity();

    @Override
    @Transactional
    public void create(E entity) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Creating a new entity: " + entity.toString()));
        }
        this.getDao().create(entity);
    }

    @Override
    @Transactional
    public E retrieve(long id) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Retrieving entity for ID: " + id));
        }
        if (this._isAuditable) {
            return this.getDao().findEnabledById(id);
        }
        return this.getDao().retrieve(id);
    }

    @Override
    @Transactional
    public void update(E entity) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating entity for ID: " + entity.getId()));
        }
        this.getDao().update(entity);
    }

    @Override
    @Transactional
    public void delete(E entity) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Deleting entity for ID: " + entity.getId()));
        }
        if (this._isAuditable) {
            entity.setEnabled(false);
            this.getDao().update(entity);
        } else {
            this.getDao().delete(entity);
        }
    }

    @Override
    @Transactional
    public void delete(long id) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Deleting entity for ID: " + id));
        }
        this.delete(this.getDao().retrieve(id));
    }

    @Override
    @Transactional
    public List<E> getAll() {
        _log.debug((Object)"Getting all enabled entities");
        return this.getDao().findAllEnabled();
    }

    @Override
    @Transactional
    public List<E> getAllWithDisabled() {
        _log.debug((Object)"Getting all enabled and disabled entities");
        return this.getDao().findAll();
    }

    @Override
    @Transactional
    public void refresh(E entity) {
        this.refresh(true, entity);
    }

    @Override
    @Transactional
    public void refresh(List<E> entities) {
        this.refresh(true, entities);
    }

    @Override
    @Transactional
    public void refresh(E ... entities) {
        this.refresh(true, (E)entities);
    }

    @Override
    @Transactional
    public void refresh(boolean initialize, E entity) {
        this.getDao().refresh(initialize, entity);
    }

    @Override
    @Transactional
    public void refresh(boolean initialize, List<E> entities) {
        for (BaseHibernateEntity entity : entities) {
            this.getDao().refresh(initialize, entity);
        }
    }

    @Override
    @Transactional
    public void refresh(boolean initialize, E ... entities) {
        for (E entity : entities) {
            this.getDao().refresh(initialize, entity);
        }
    }

    @Override
    public String validate(E entity) {
        return null;
    }

    protected abstract BaseHibernateDAO<E> getDao();
}

