/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.orm.hibernate;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.hibernate.annotations.Cache;
import org.nrg.framework.orm.hibernate.BaseHibernateEntity;
import org.nrg.framework.orm.hibernate.exceptions.InvalidDirectParameterizedClassUsageException;

public abstract class AbstractParameterizedWorker<E extends BaseHibernateEntity> {
    public static final String DEFAULT_CACHE_REGION = "nrg";
    private final Class<E> _parameterizedType;
    private final String _cacheRegion;

    protected AbstractParameterizedWorker() {
        ParameterizedType parameterizedType = null;
        Class<?> clazz = this.getClass();
        while (parameterizedType == null) {
            Type superclass = clazz.getGenericSuperclass();
            if (superclass == null) {
                throw new RuntimeException("Can't find superclass as parameterized type!");
            }
            if (superclass instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)superclass;
                if (!(parameterizedType.getActualTypeArguments()[0] instanceof TypeVariable)) continue;
                throw new InvalidDirectParameterizedClassUsageException("When using a parameterized worker directly (i.e. with a generic subclass), you must call the AbstractParameterizedWorker constructor that takes the parameterized type directly.");
            }
            clazz = clazz.getSuperclass();
        }
        this._parameterizedType = (Class)parameterizedType.getActualTypeArguments()[0];
        this._cacheRegion = this.extractCacheRegion(this._parameterizedType);
    }

    protected AbstractParameterizedWorker(Class<E> clazz) {
        this._parameterizedType = clazz;
        this._cacheRegion = this.extractCacheRegion(this._parameterizedType);
    }

    protected Class<E> getParameterizedType() {
        return this._parameterizedType;
    }

    protected String getCacheRegion() {
        return this._cacheRegion;
    }

    private String extractCacheRegion(Class<E> type) {
        return type.isAnnotationPresent(Cache.class) ? type.getAnnotation(Cache.class).region() : DEFAULT_CACHE_REGION;
    }
}

