/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.orm.hibernate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.cfg.AnnotationConfiguration;
import org.nrg.framework.orm.hibernate.HibernateEntityPackageList;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.hibernate3.annotation.AnnotationSessionFactoryBean;

public class AggregatedAnnotationSessionFactoryBean
extends AnnotationSessionFactoryBean
implements ApplicationContextAware {
    private ApplicationContext _context;
    private Set<String> _packagesToScan = new HashSet<String>();

    public void setPackagesToScan(String[] packagesToScan) {
        this._packagesToScan.addAll(Arrays.asList(packagesToScan));
        super.setPackagesToScan(this._packagesToScan.toArray(new String[this._packagesToScan.size()]));
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this._context = context;
    }

    protected void scanPackages(AnnotationConfiguration configuration) {
        String[] packages = this.getHibernateEntityPackages();
        this.setPackagesToScan(packages);
        super.scanPackages(configuration);
    }

    private String[] getHibernateEntityPackages() {
        Map beans = this._context.getBeansOfType(HibernateEntityPackageList.class);
        ArrayList<String> packages = new ArrayList<String>();
        if (beans != null) {
            for (Object item : beans.values()) {
                if (!(item instanceof HibernateEntityPackageList)) continue;
                packages.addAll((HibernateEntityPackageList)item);
            }
        }
        return packages.toArray(new String[packages.size()]);
    }
}

