/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.orm.hibernate;

import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.cfg.NamingStrategy;

public class PrefixedTableNamingStrategy
extends ImprovedNamingStrategy {
    public static final NamingStrategy INSTANCE = new PrefixedTableNamingStrategy();
    private static final long serialVersionUID = -472772844764070830L;
    private String _prefix;

    public void setPrefix(String prefix) {
        this._prefix = !prefix.endsWith("_") ? prefix + "_" : prefix;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String classToTableName(String className) {
        return this.prefixIfNeeded(super.classToTableName(className));
    }

    public String tableName(String tableName) {
        return this.prefixIfNeeded(super.tableName(tableName));
    }

    public String collectionTableName(String ownerEntity, String ownerEntityTable, String associatedEntity, String associatedEntityTable, String propertyName) {
        return this.prefixIfNeeded(super.collectionTableName(ownerEntity, ownerEntityTable, associatedEntity, associatedEntityTable, propertyName));
    }

    public String logicalCollectionTableName(String tableName, String ownerEntityTable, String associatedEntityTable, String propertyName) {
        return this.prefixIfNeeded(super.logicalCollectionTableName(tableName, ownerEntityTable, associatedEntityTable, propertyName));
    }

    private String prefixIfNeeded(String name) {
        if (this._prefix == null || this._prefix.length() == 0) {
            throw new RuntimeException("You must specify a prefix to use this naming strategy!");
        }
        if (name.startsWith(this._prefix)) {
            return name;
        }
        return this._prefix + name;
    }
}

