/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.pinto;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nrg.framework.pinto.ArgCount;
import org.nrg.framework.pinto.Parameter;
import org.nrg.framework.pinto.ParameterData;
import org.nrg.framework.pinto.PintoApplication;
import org.nrg.framework.pinto.PintoException;
import org.nrg.framework.pinto.PintoExceptionType;
import org.nrg.framework.pinto.PintoStreamAdapter;
import org.nrg.framework.pinto.Value;
import org.nrg.framework.utilities.Reflection;

public abstract class AbstractPintoBean {
    private static final Log _log = LogFactory.getLog(AbstractPintoBean.class);
    private static final String PREFIX = " ";
    private static final int HANGING_INDENT = 20;
    private static final String INDENT_FILLER = "\n" + CharBuffer.allocate(20).toString().replace('\u0000', ' ');
    private static final int WIDTH = 80;
    private static final String SHORT_OPTION_DELIMITER = "-";
    private static final String LONG_OPTION_DELIMITER = "--";
    private static final String[] OPTION_DELIMITERS = new String[]{"--", "-"};
    public static final String PROPERTY_INDICATOR = "property:";
    private PrintStream _printStream = System.out;
    private final Object _parent;
    private boolean _help;
    private boolean _version = false;
    private String _outputStreamAdapter;
    private List<String> _arguments;
    private Map<String, List<String>> _parameters = new LinkedHashMap<String, List<String>>();
    private List<String> _trailing = new ArrayList<String>();
    private Map<String, ParameterData> _parametersByShortOption = new HashMap<String, ParameterData>();
    private Map<String, ParameterData> _parametersByLongOption = new HashMap<String, ParameterData>();

    protected AbstractPintoBean(Object parent, String[] arguments) throws PintoException {
        this(parent, arguments, System.out);
    }

    protected AbstractPintoBean(Object parent, String[] arguments, PrintStream printStream) throws PintoException {
        try {
            assert (parent != null) : "You must specify the parent for your pinto bean.";
            this._arguments = Arrays.asList(arguments);
            this._parent = parent;
            this.scan();
            this.harvest();
            this.prune();
            this._printStream = this.getOutputStream();
            if (this.getHelp()) {
                this.displayHelp();
            } else if (this.getVersion()) {
                this.displayVersion();
            } else {
                this.validate();
            }
        }
        catch (PintoException exception) {
            String parameter = exception.getParameter();
            if (!StringUtils.isBlank((String)parameter)) {
                printStream.println("Found error with parameter: " + parameter + ":");
            }
            printStream.println("Error type: " + (Object)((Object)exception.getType()));
            printStream.println(exception.getMessage());
            throw exception;
        }
    }

    public abstract void validate() throws PintoException;

    public void setPrintStream(PrintStream printStream) {
        this._printStream = printStream;
    }

    public PrintStream getPrintStream() {
        return this._printStream;
    }

    @Parameter(value="h", longOption="help", help="Displays this help text.", argCount=ArgCount.StandAlone)
    public void setHelp(boolean help) {
        this._help = help;
    }

    @Value(value="h")
    public boolean getHelp() {
        return this._help;
    }

    @Parameter(value="v", longOption="version", argCount=ArgCount.StandAlone, help="Displays the version of this application.")
    public void setVersion(boolean version) {
        this._version = version;
    }

    @Value(value="v")
    public boolean getVersion() {
        return this._version;
    }

    @Parameter(value="osa", longOption="outputStreamAdapter", help="Specifies an output stream adapter implementation to handle redirecting the output from your application.")
    public void setOutputStreamAdapter(String outputStreamAdapter) {
        this._outputStreamAdapter = outputStreamAdapter;
    }

    @Value(value="osa")
    public String getOutputStreamAdapter() {
        return this._outputStreamAdapter;
    }

    public List<String> getTrailingArguments() {
        return this._trailing;
    }

    public boolean getShouldContinue() {
        return !this._help && !this._version;
    }

    public void displayHelp() {
        if (this._parametersByShortOption == null || this._parametersByShortOption.size() == 0) {
            this.getPrintStream().println("No parameters found for this application!");
        } else {
            String copyright;
            String introduction;
            String appName;
            PintoApplication application = this._parent.getClass().getAnnotation(PintoApplication.class);
            if (application == null) {
                appName = this._parent.getClass().getSimpleName();
                introduction = null;
                copyright = null;
            } else {
                appName = application.value();
                copyright = application.copyright();
                introduction = application.introduction();
            }
            this.getPrintStream().println(appName);
            if (!StringUtils.isBlank((String)copyright)) {
                this.getPrintStream().println(copyright);
            }
            if (!StringUtils.isBlank((String)introduction)) {
                this.getPrintStream().println(introduction);
            }
            this.getPrintStream().println();
            for (ParameterData parameter : this._parametersByShortOption.values()) {
                int length;
                StringBuilder parameterText = new StringBuilder(PREFIX);
                parameterText.append(SHORT_OPTION_DELIMITER).append(parameter.getShortOption());
                if (parameter.hasLongOption()) {
                    parameterText.append(", ").append(LONG_OPTION_DELIMITER).append(parameter.getLongOption());
                }
                if ((length = parameterText.length()) > 19) {
                    parameterText.append(INDENT_FILLER);
                } else {
                    parameterText.append(CharBuffer.allocate(20 - length).toString().replace('\u0000', ' '));
                }
                parameterText.append(WordUtils.wrap((String)parameter.getHelp(), (int)60, (String)INDENT_FILLER, (boolean)true));
                this.getPrintStream().println(parameterText.toString());
            }
        }
    }

    protected void displayVersion() throws PintoException {
        String copyright;
        String version;
        String appName;
        PintoApplication application = this._parent.getClass().getAnnotation(PintoApplication.class);
        if (application == null) {
            appName = this._parent.getClass().getSimpleName();
            version = this.getVersionFromParent();
            copyright = null;
        } else {
            appName = this.resolveAttribute(application.value());
            version = application.version();
            version = StringUtils.isBlank((String)version) ? this.getVersionFromParent() : this.resolveAttribute(version);
            copyright = this.resolveAttribute(application.copyright());
        }
        this.getPrintStream().println(appName + ", version " + version);
        if (!StringUtils.isBlank((String)copyright)) {
            this.getPrintStream().println(copyright);
        }
    }

    protected Object convertStringToType(Class<?> type, String argument) throws PintoException {
        Object object;
        if (type == String.class) {
            object = argument;
        } else if (type == Integer.class || type == Integer.TYPE) {
            object = Integer.parseInt(argument);
        } else if (type == Long.class || type == Long.TYPE) {
            object = Long.parseLong(argument);
        } else if (type == Float.class || type == Float.TYPE) {
            object = Float.valueOf(Float.parseFloat(argument));
        } else if (type == Double.class || type == Double.TYPE) {
            object = Double.parseDouble(argument);
        } else if (type == Character.class || type == Character.TYPE) {
            object = Character.valueOf(argument.toCharArray()[0]);
        } else if (type == Byte.class || type == Byte.TYPE) {
            object = Byte.parseByte(argument);
        } else if (type == Short.class || type == Short.TYPE) {
            object = Short.parseShort(argument);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            object = Boolean.parseBoolean(argument);
        } else if (type == File.class) {
            object = new File(argument);
        } else if (type == URI.class) {
            try {
                object = new URI(argument);
            }
            catch (URISyntaxException exception) {
                throw new PintoException(PintoExceptionType.SyntaxFormat, "The value " + argument + " is not a valid URI.", exception);
            }
        } else {
            throw new PintoException(PintoExceptionType.UnknownParameterTypes, "I don't know how to convert to the type " + type.getName());
        }
        return object;
    }

    private void scan() throws PintoException {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            ParameterData parameter;
            Parameter annotation = method.getAnnotation(Parameter.class);
            if (annotation == null) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Found command-line parameter annotation " + annotation.value() + " on " + this.getClass().getName() + "." + method.getName() + "() method"));
            }
            if (this._parametersByShortOption.containsKey((parameter = new ParameterData(method, annotation)).getShortOption())) {
                throw new PintoException(PintoExceptionType.DuplicateParameter, "Your application has multiple declarations of the short option " + parameter.getShortOption());
            }
            this._parametersByShortOption.put(parameter.getShortOption(), parameter);
            String longOption = parameter.getLongOption();
            if (StringUtils.isBlank((String)longOption)) continue;
            if (this._parametersByLongOption.containsKey(parameter.getLongOption())) {
                throw new PintoException(PintoExceptionType.DuplicateParameter, "Your application has multiple declarations of the long option " + parameter.getLongOption());
            }
            this._parametersByLongOption.put(longOption, parameter);
        }
    }

    private void harvest() throws PintoException {
        ParameterData parameter = null;
        for (String argument : this._arguments) {
            ArgCount argCount;
            if (this.isParameter(argument)) {
                if (this._trailing.size() > 0) {
                    throw new PintoException(PintoExceptionType.SyntaxFormat, argument, "Trailing arguments were found prior to the parameter " + argument + ". Check that you've supplied only the expected number of arguments to each parameter.");
                }
                ParameterData foundParameter = this.getParameterData(argument);
                if (parameter != null) {
                    argCount = parameter.getArgCount();
                    int argSize = this._parameters.get(parameter.getShortOption()).size();
                    if (argSize == 0 && (argCount == ArgCount.ZeroToN || argCount == ArgCount.StandAlone)) break;
                    if (argCount == ArgCount.OneArgument && argSize != 1) {
                        throw new PintoException(PintoExceptionType.SyntaxFormat, "Not enough arguments specified for parameter " + parameter.getShortOption() + ", requires exactly one");
                    }
                    if (argCount == ArgCount.OneToN && argSize == 0) {
                        throw new PintoException(PintoExceptionType.SyntaxFormat, "Not enough arguments specified for parameter " + parameter.getShortOption() + ", requires one or more");
                    }
                    if (argCount == ArgCount.SpecificCount && argSize != parameter.getExactArgCount()) {
                        throw new PintoException(PintoExceptionType.SyntaxFormat, "Not enough arguments specified for parameter " + parameter.getShortOption() + ", requires " + parameter.getExactArgCount());
                    }
                }
                parameter = foundParameter;
                this._parameters.put(parameter.getShortOption(), new ArrayList());
                if (parameter.getArgCount() != ArgCount.StandAlone) continue;
                parameter = null;
                continue;
            }
            if (parameter == null) {
                this._trailing.add(argument);
                continue;
            }
            List<String> args = this._parameters.get(parameter.getShortOption());
            args.add(argument);
            argCount = parameter.getArgCount();
            switch (argCount) {
                case OneArgument: {
                    if (args.size() > 1) {
                        throw new PintoException(PintoExceptionType.SyntaxFormat, "Too many arguments specified for parameter " + parameter.getShortOption());
                    }
                    parameter = null;
                    break;
                }
                case SpecificCount: {
                    if (args.size() <= parameter.getExactArgCount()) break;
                    throw new PintoException(PintoExceptionType.SyntaxFormat, "Too many arguments specified for parameter " + parameter.getShortOption());
                }
            }
        }
    }

    private void prune() throws PintoException {
        for (String parameterId : this._parameters.keySet()) {
            ParameterData parameter = this._parametersByShortOption.get(parameterId);
            List<String> arguments = this._parameters.get(parameterId);
            this.validateArgCount(parameter, arguments);
            Method method = parameter.getMethod();
            try {
                if (parameter.getArgCount() == ArgCount.StandAlone) {
                    method.invoke((Object)this, true);
                    continue;
                }
                try {
                    Object[] coercedArguments = this.coerceArguments(method, arguments);
                    method.invoke((Object)this, coercedArguments);
                }
                catch (PintoException exception) {
                    if (exception.getType() == PintoExceptionType.UnknownParameterTypes && StringUtils.isBlank((String)exception.getMessage())) {
                        throw new PintoException(PintoExceptionType.UnknownParameterTypes, "The parameter " + parameterId + " has unknown parameter types. Check your set method for compatible parameter types.");
                    }
                    if (exception.getType() == PintoExceptionType.SyntaxFormat) {
                        StringBuilder message = new StringBuilder("The parameter " + parameterId + " has a syntax error. Check that your arguments match the parameter requirements.");
                        if (!StringUtils.isBlank((String)exception.getMessage())) {
                            message.append(" The specific error message is:\n\n").append(exception.getMessage());
                        }
                        throw new PintoException(PintoExceptionType.SyntaxFormat, parameterId, message.toString());
                    }
                    throw exception;
                }
            }
            catch (IllegalAccessException exception) {
                throw new PintoException(PintoExceptionType.Configuration, parameter.getShortOption(), "Unable to call the " + method.getName() + " method configured for handling parameter", exception);
            }
            catch (InvocationTargetException exception) {
                throw new PintoException(PintoExceptionType.Configuration, parameter.getShortOption(), "Unable to call the " + method.getName() + " method configured for handling parameter", exception);
            }
        }
    }

    private Object[] coerceArguments(Method method, List<String> arguments) throws PintoException {
        Object[] objectArray;
        boolean isArrayParameter;
        Class<?>[] types = method.getParameterTypes();
        if (types == null || types.length == 0) {
            throw new PintoException(PintoExceptionType.UnknownParameterTypes);
        }
        boolean bl = isArrayParameter = types.length == 1 && types[0].isArray();
        if (types.length != arguments.size() && !isArrayParameter) {
            throw new PintoException(PintoExceptionType.SyntaxFormat);
        }
        Class<?> type = isArrayParameter ? types[0].getComponentType() : null;
        ArrayList<Object> coercedArguments = new ArrayList<Object>(types.length);
        for (int index = 0; index < arguments.size(); ++index) {
            if (!isArrayParameter) {
                type = types[index];
            }
            coercedArguments.add(this.convertStringToType(type, arguments.get(index)));
        }
        if (isArrayParameter) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = coercedArguments.toArray((Object[])Array.newInstance(types[0].getComponentType(), coercedArguments.size()));
        } else {
            objectArray = coercedArguments.toArray();
        }
        return objectArray;
    }

    private void validateArgCount(ParameterData parameter, List<String> arguments) throws PintoException {
        String parameterId = parameter.getShortOption();
        int argCount = arguments.size();
        ArgCount ArgCount2 = parameter.getArgCount();
        switch (ArgCount2) {
            case StandAlone: {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Found parameter " + parameterId + " specified as StandAlone parameter, comes with " + argCount + " arguments"));
                }
                if (argCount <= 0) break;
                throw new PintoException(PintoExceptionType.SyntaxFormat, "The parameter " + parameterId + " does not accept any arguments.");
            }
            case OneArgument: {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Found parameter " + parameterId + " specified as OneArgument parameter, comes with " + argCount + " arguments"));
                }
                if (argCount == 1) break;
                throw new PintoException(PintoExceptionType.SyntaxFormat, "The parameter " + parameterId + " only accepts a single argument.");
            }
            case OneToN: {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Found parameter " + parameterId + " specified as OneToN parameter, comes with " + argCount + " arguments"));
                }
                if (argCount != 0) break;
                throw new PintoException(PintoExceptionType.SyntaxFormat, "The parameter " + parameterId + " requires one or more arguments.");
            }
            case SpecificCount: {
                int acceptedArgCount = parameter.getExactArgCount();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Found parameter " + parameterId + " specified as SpecificCount parameter with " + acceptedArgCount + " arguments required, comes with " + argCount + " arguments"));
                }
                if (argCount == acceptedArgCount) break;
                throw new PintoException(PintoExceptionType.SyntaxFormat, "The parameter " + parameterId + " requires exactly " + acceptedArgCount + " arguments.");
            }
            case ZeroToN: {
                if (!_log.isDebugEnabled()) break;
                _log.debug((Object)("Found parameter " + parameterId + " specified as ZeroToN parameter, comes  with " + argCount + " arguments"));
            }
        }
    }

    private ParameterData getParameterData(String parameter) throws PintoException {
        if (parameter.startsWith(LONG_OPTION_DELIMITER) && this._parametersByLongOption.containsKey(parameter = parameter.substring(LONG_OPTION_DELIMITER.length()))) {
            return this._parametersByLongOption.get(parameter);
        }
        if (parameter.startsWith(SHORT_OPTION_DELIMITER) && this._parametersByShortOption.containsKey(parameter = parameter.substring(SHORT_OPTION_DELIMITER.length()))) {
            return this._parametersByShortOption.get(parameter);
        }
        throw new PintoException(PintoExceptionType.UnknownParameter, parameter, "The parameter " + parameter + " is not a valid parameter.");
    }

    private boolean isParameter(String argument) {
        return StringUtils.startsWithAny((String)argument, (String[])OPTION_DELIMITERS);
    }

    private String getVersionFromParent() throws PintoException {
        Method getVersion = null;
        try {
            getVersion = this._parent.getClass().getMethod("getVersion", new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
        if (getVersion != null) {
            try {
                return (String)getVersion.invoke(this._parent, new Object[0]);
            }
            catch (Exception exception) {
                throw new PintoException(PintoExceptionType.Configuration, "v", "Version method was found, but throws an error", exception);
            }
        }
        return this.getVersionFromParentProperties();
    }

    private String getVersionFromParentProperties() throws PintoException {
        String version = this.getPropertyFromParentProperties("version");
        return StringUtils.isBlank((String)version) ? "Unknown" : version;
    }

    private String getPropertyFromParentProperties(String property) throws PintoException {
        Properties properties = null;
        Method getProperties = null;
        try {
            getProperties = this._parent.getClass().getMethod("getProperties", new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
        if (getProperties != null) {
            try {
                properties = (Properties)getProperties.invoke(this._parent, new Object[0]);
            }
            catch (Exception exception) {
                throw new PintoException(PintoExceptionType.Configuration, "v", "Properties method was found, but throws an error", exception);
            }
        }
        if (properties == null) {
            properties = Reflection.getPropertiesForClass(this._parent.getClass());
        }
        return properties == null ? null : properties.getProperty(property);
    }

    private String resolveAttribute(String value) {
        if (value.startsWith(PROPERTY_INDICATOR)) {
            try {
                return this.getPropertyFromParentProperties(value.substring(PROPERTY_INDICATOR.length()));
            }
            catch (PintoException pintoException) {
                // empty catch block
            }
        }
        return value;
    }

    private PrintStream getOutputStream() throws PintoException {
        String outputStreamAdapter = this.getOutputStreamAdapter();
        if (StringUtils.isBlank((String)outputStreamAdapter)) {
            return System.out;
        }
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(outputStreamAdapter);
            PintoStreamAdapter adapter = (PintoStreamAdapter)clazz.newInstance();
            return adapter.getOutputStream();
        }
        catch (ClassNotFoundException e) {
            throw new PintoException(PintoExceptionType.InvalidOutputStreamAdapter, "Couldn't find output stream adapter class: " + outputStreamAdapter);
        }
        catch (InstantiationException e) {
            throw new PintoException(PintoExceptionType.InvalidOutputStreamAdapter, "Couldn't create new instance of output stream adapter class: " + outputStreamAdapter);
        }
        catch (IllegalAccessException e) {
            throw new PintoException(PintoExceptionType.InvalidOutputStreamAdapter, "Can't access constructor of output stream adapter class: " + outputStreamAdapter);
        }
    }
}

