/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.pinto;

import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nrg.framework.pinto.ArgCount;
import org.nrg.framework.pinto.Parameter;

public class ParameterData {
    private static final Log _log = LogFactory.getLog(ParameterData.class);
    private final Method _method;
    private final String _shortOption;
    private final String _longOption;
    private final ArgCount _argCount;
    private final int _exactArgCount;
    private final String _help;

    public ParameterData(Method method, Parameter parameter) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Creating new parameter data object:");
            _log.debug((Object)(" *** Short option:  " + parameter.value()));
            _log.debug((Object)(" *** Long option:   " + parameter.longOption()));
            _log.debug((Object)(" *** Help text:     " + parameter.help()));
            _log.debug((Object)(" *** Expected type: " + parameter.type()));
        }
        this._method = method;
        this._shortOption = parameter.value();
        this._longOption = parameter.longOption();
        this._argCount = parameter.argCount();
        this._exactArgCount = parameter.exactArgCount();
        this._help = parameter.help();
    }

    public Method getMethod() {
        return this._method;
    }

    public String getShortOption() {
        return this._shortOption;
    }

    public boolean hasLongOption() {
        return !StringUtils.isBlank((String)this._longOption);
    }

    public String getLongOption() {
        return this._longOption;
    }

    public ArgCount getArgCount() {
        return this._argCount;
    }

    public int getExactArgCount() {
        return this._exactArgCount;
    }

    public String getHelp() {
        return this._help;
    }
}

