/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.pinto;

import java.util.HashMap;
import java.util.Map;

public enum PintoExceptionType {
    UnknownParameter(0),
    SyntaxFormat(1),
    UnsupportedFeature(2),
    DuplicateParameter(3),
    Configuration(4),
    UnknownParameterTypes(5),
    InvalidOutputStreamAdapter(6);

    private static final Map<Integer, PintoExceptionType> _codes;
    private final int _code;

    private PintoExceptionType(int code) {
        this._code = code;
    }

    public int getCode() {
        return this._code;
    }

    public static PintoExceptionType code(String code) {
        return PintoExceptionType.code(Integer.parseInt(code));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PintoExceptionType code(int code) {
        if (!_codes.isEmpty()) return _codes.get(code);
        Class<PintoExceptionType> clazz = PintoExceptionType.class;
        synchronized (PintoExceptionType.class) {
            for (PintoExceptionType typeCode : PintoExceptionType.values()) {
                _codes.put(typeCode.getCode(), typeCode);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _codes.get(code);
        }
    }

    public String toString() {
        return this.name();
    }

    static {
        _codes = new HashMap<Integer, PintoExceptionType>();
    }
}

