/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.services.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nrg.framework.services.PropertiesService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.web.context.support.XmlWebApplicationContext;

@Service
public class DefaultPropertiesService
implements PropertiesService,
ApplicationContextAware {
    private static final Log _log = LogFactory.getLog(DefaultPropertiesService.class);
    private List<File> _repositories;
    private ApplicationContext _context;
    private Map<String, Properties> _bundles;

    @PostConstruct
    public void initialize() {
        List repositories;
        try {
            repositories = (List)this._context.getBean("propertiesRepositories", List.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            DefaultPropertiesService.handleNoRepositoriesState();
            return;
        }
        if (repositories == null || repositories.size() == 0) {
            DefaultPropertiesService.handleNoRepositoriesState();
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Found repositories list containing " + repositories.size() + " items."));
        }
        this._repositories = new ArrayList<File>();
        for (Object repository : repositories) {
            File file = new File(repository.toString());
            assert (file.exists()) : "The repository " + file.getAbsolutePath() + " does not exist!";
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding properties repository: " + file.getAbsolutePath()));
            }
            this._repositories.add(file);
        }
        this.refreshBundles();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this._context = context;
    }

    @Override
    public List<File> getRepositories() {
        return this._repositories;
    }

    @Override
    public Map<String, Properties> getBundles() {
        return this._bundles;
    }

    @Override
    public void refreshBundles() {
        if (this._repositories == null) {
            DefaultPropertiesService.handleNoRepositoriesState();
            return;
        }
        this._bundles = new HashMap<String, Properties>();
        for (File repository : this._repositories) {
            File[] propertyFiles;
            if (!repository.exists() && !repository.isAbsolute()) {
                if (this._context == null || !(this._context instanceof XmlWebApplicationContext)) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Unable to resolve relative repository, no appropriate Spring Web context found: " + repository.getPath()));
                    continue;
                }
                ServletContext context = ((XmlWebApplicationContext)this._context).getServletContext();
                if (context == null) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Unable to resolve relative repository, no appropriate Web application context found: " + repository.getPath()));
                    continue;
                }
                File resolved = new File(context.getRealPath(repository.getPath()));
                if (!resolved.exists()) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Failed to resolve relative repository " + repository.getPath() + " to absolute path " + resolved.getAbsolutePath()));
                    continue;
                }
                repository = resolved;
            }
            if ((propertyFiles = repository.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(".*\\.properties") || name.matches(".*\\.xml");
                }
            })) != null && propertyFiles.length > 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Found " + propertyFiles.length + " properties bundles in repository: " + repository.getAbsolutePath()));
                }
                for (File propertyFile : propertyFiles) {
                    try {
                        String name;
                        String extension = FilenameUtils.getExtension((String)propertyFile.getName());
                        Properties properties = new Properties();
                        if (extension.equals("properties")) {
                            properties.load(new FileReader(propertyFile));
                        } else {
                            properties.loadFromXML(new FileInputStream(propertyFile));
                        }
                        String filename = FilenameUtils.removeExtension((String)propertyFile.getName());
                        if (properties.containsKey("module")) {
                            name = DefaultPropertiesService.generateModulePropertiesKey(properties.getProperty("module"), filename);
                            if (_log.isDebugEnabled()) {
                                _log.debug((Object)("Found bundle ID from the bundle's module property definition: " + name));
                            }
                        } else {
                            name = DefaultPropertiesService.generateModulePropertiesKey(filename, filename);
                            if (_log.isDebugEnabled()) {
                                _log.debug((Object)("Using default bundle ID from the bundle's file name: " + name));
                            }
                        }
                        this._bundles.put(name, properties);
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("No properties files were found at the repository location: " + repository.getAbsolutePath()));
        }
    }

    @Override
    public Properties getProperties(String bundle) {
        return this.getProperties(bundle, bundle);
    }

    @Override
    public Properties getProperties(String module, String bundle) {
        if (this.getBundles() == null) {
            return null;
        }
        return this.getBundles().get(DefaultPropertiesService.generateModulePropertiesKey(module, bundle));
    }

    private static void handleNoRepositoriesState() {
        _log.warn((Object)"No repositories configured for the properties service");
    }

    private static String generateModulePropertiesKey(String module, String properties) {
        return String.format("%s.%s", module, properties);
    }
}

