/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.framework.utilities;

import java.text.ParseException;

public class Messages {
    private Messages() {
    }

    public static String formatHtml(String message, int width) throws ParseException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html>");
        boolean insideTag = false;
        char[] chars = message.toCharArray();
        int lineCount = 0;
        for (int index = 0; index < chars.length; ++index) {
            char c = chars[index];
            if (c == '<' && insideTag || c == '>' && !insideTag) {
                throw new ParseException("Invalid format: nested tags", index);
            }
            if (c == '<') {
                insideTag = true;
            } else if (insideTag && c == '>') {
                insideTag = false;
            }
            buffer.append(c);
            if (++lineCount != width) continue;
            buffer.reverse();
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    public static enum Format {
        Html;

    }
}

