/*
 * Decompiled with CFR 0.152.
 */
package org.nrg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nrg.ProgressListener;

public final class IOUtils {
    private static final int BUF_SIZE = 512;

    private IOUtils() {
    }

    public static void copy(OutputStream out, InputStream in, int nbytes) throws IOException {
        int chunk;
        byte[] buf = new byte[512];
        for (int remaining = nbytes; remaining > 0; remaining -= chunk) {
            int nread;
            chunk = Math.min(512, remaining);
            for (int buf_i = 0; buf_i < chunk; buf_i += nread) {
                nread = in.read(buf, buf_i, chunk - buf_i);
                if (-1 != nread) continue;
                throw new EOFException();
            }
            out.write(buf, 0, chunk);
        }
    }

    public static void copy(OutputStream out, InputStream in, ProgressListener pl) throws IOException {
        byte[] buf = new byte[512];
        int nread;
        while (-1 != (nread = in.read(buf))) {
            out.write(buf, 0, nread);
            if (null == pl) continue;
            pl.incrementProgress(nread);
        }
        return;
    }

    public static void copy(OutputStream out, InputStream in) throws IOException {
        IOUtils.copy(out, in, null);
    }
}

