/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.nrg.IOUtils;
import org.nrg.ProgressListener;
import org.nrg.ecat.Header;
import org.nrg.ecat.HeaderModification;
import org.nrg.ecat.MainHeader;
import org.nrg.ecat.var.Variable;

public class MatrixData
implements Comparable {
    private static final int BLOCK_SIZE = 512;
    private final Map values = new LinkedHashMap();
    private final MainHeader mainHeader;

    private MatrixData(InputStream in, Map requestedVars) throws IOException {
        this.mainHeader = new MainHeader(in);
        if (requestedVars.containsKey(Header.MAIN)) {
            for (Variable v : (Collection)requestedVars.get(Header.MAIN)) {
                this.values.put(v, this.mainHeader.getValue(v));
            }
        }
    }

    public MatrixData(InputStream in, Collection requestedVars) throws IOException {
        this(in, MatrixData.arrangeRequestedVars(requestedVars));
    }

    public MatrixData(InputStream in) throws IOException {
        this(in, Collections.EMPTY_MAP);
    }

    public int compareTo(MatrixData o) {
        Date d1 = (Date)this.getMainHeader().getValue(MainHeader.SCAN_START_TIME);
        Date d2 = (Date)o.getMainHeader().getValue(MainHeader.SCAN_START_TIME);
        return d1.compareTo(d2);
    }

    public int compareTo(Object o) {
        return this.compareTo((MatrixData)o);
    }

    private static Map arrangeRequestedVars(Collection requestedVars) {
        HashMap m = new HashMap();
        for (Variable v : requestedVars) {
            if (!m.containsKey(v)) {
                m.put(v, new TreeSet());
            }
            ((Collection)m.get(v)).add(v);
        }
        return m;
    }

    public MainHeader getMainHeader() {
        return this.mainHeader;
    }

    private static void copyOneHeaderWithModifications(OutputStream out, InputStream in, List modifications) throws IOException {
        int hpos = 0;
        Iterator i = modifications.iterator();
        while (i.hasNext()) {
            HeaderModification mod = (HeaderModification)i.next();
            int offset = mod.getOffset();
            assert (offset >= hpos);
            if (offset > hpos) {
                IOUtils.copy(out, in, offset - hpos);
                hpos = offset;
            }
            hpos += mod.modify(out, in);
            i.remove();
        }
        if (hpos < 512) {
            IOUtils.copy(out, in, 512 - hpos);
        }
    }

    private static Map sortModifications(Collection modifications) {
        HashMap m = new HashMap();
        for (HeaderModification hm : modifications) {
            Header.Type type = hm.getHeaderType();
            if (!m.containsKey(type)) {
                m.put(type, new ArrayList());
            }
            ((Collection)m.get(type)).add(hm);
        }
        Iterator<Object> i = m.values().iterator();
        while (i.hasNext()) {
            Collections.sort((List)i.next());
        }
        return m;
    }

    public static void copyWithModifications(OutputStream out, InputStream in, Collection modifications, ProgressListener progress) throws IOException {
        Map m = MatrixData.sortModifications(modifications);
        MatrixData.copyOneHeaderWithModifications(out, in, (List)m.get(Header.MAIN));
        IOUtils.copy(out, in, progress);
    }

    public static void copyClearing(OutputStream out, InputStream in, Collection variables, ProgressListener progress) throws IOException {
        ArrayList<HeaderModification> mods = new ArrayList<HeaderModification>(variables.size());
        Iterator i = variables.iterator();
        while (i.hasNext()) {
            mods.add(((Variable)i.next()).createClearModification());
        }
        MatrixData.copyWithModifications(out, in, mods, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            FileInputStream in = new FileInputStream(args[i]);
            try {
                MatrixData m = new MatrixData(in);
                MainHeader mainHeader = m.getMainHeader();
                System.out.println("Main header:");
                System.out.println(mainHeader);
                continue;
            }
            finally {
                in.close();
            }
        }
    }
}

