/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.nrg.ecat.MainHeader;
import org.nrg.ecat.MatrixData;
import org.nrg.ecat.var.Variable;

public final class MatrixDataFile
implements Comparable {
    private final File f;
    private final MatrixData data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatrixDataFile(File f) throws IOException {
        this.f = MatrixDataFile.getFullPathFile(f);
        FileInputStream in = new FileInputStream(this.f);
        try {
            this.data = new MatrixData(in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static File getFullPathFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    public int compareTo(MatrixDataFile o) {
        return this.data.compareTo(o.data);
    }

    public int compareTo(Object o) {
        return this.compareTo((MatrixDataFile)o);
    }

    private Object getMainHeader(Variable v) {
        return this.data.getMainHeader().getValue(v);
    }

    public Date getDate() {
        return (Date)this.getMainHeader(MainHeader.SCAN_START_TIME);
    }

    public String getDescription() {
        return this.getMainHeader(MainHeader.STUDY_DESCRIPTION).toString();
    }

    public File getFile() {
        return this.f;
    }

    public String getName() {
        return this.f.getName();
    }

    public String getPath() {
        return this.f.getPath();
    }

    public String getPatientID() {
        return this.getMainHeader(MainHeader.PATIENT_ID).toString();
    }

    public long getSize() {
        return this.f.length();
    }
}

