/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat.var;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nrg.Utils;
import org.nrg.ecat.AbstractHeaderModification;
import org.nrg.ecat.Header;
import org.nrg.ecat.HeaderModification;
import org.nrg.ecat.var.Variable;

public abstract class AbstractVariable
implements Variable {
    private Header.Type type;
    private String name;
    private int offset;

    protected AbstractVariable(Header.Type type, String name, int offset) {
        this.type = type;
        this.name = name;
        this.offset = offset;
    }

    @Override
    public final Header.Type getHeaderType() {
        return this.type;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getOffset() {
        return this.offset;
    }

    public final int compareTo(Object o) {
        Variable other = (Variable)o;
        int hc = this.type.compareTo(other.getHeaderType());
        return 0 == hc ? Utils.compare(this.offset, other.getOffset()) : hc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.offset).append(" ").append(this.name);
        return sb.toString();
    }

    protected static byte[] readFull(InputStream in, int size) throws IOException {
        int nr;
        byte[] bytes = new byte[size];
        for (int n = 0; n < size; n += nr) {
            nr = in.read(bytes, n, size - n);
            if (nr < 0) {
                throw new EOFException("End of file reached where " + size + " byte field was expected");
            }
            assert (nr > 0);
        }
        return bytes;
    }

    protected static int read4ByteInt(InputStream in) throws IOException {
        byte[] bytes = AbstractVariable.readFull(in, 4);
        int ib3 = bytes[0] & 0xFF;
        int ib2 = bytes[1] & 0xFF;
        int ib1 = bytes[2] & 0xFF;
        int ib0 = bytes[3] & 0xFF;
        return ((ib3 << 8 | ib2) << 8 | ib1) << 8 | ib0;
    }

    public HeaderModification createClearModification(final int size) {
        return new AbstractHeaderModification(this.getHeaderType(), this.getOffset()){

            @Override
            public int modify(OutputStream to, InputStream from) throws IOException {
                AbstractVariable.readFull(from, size);
                to.write(new byte[size]);
                return size;
            }
        };
    }
}

