/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat.var;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.nrg.ecat.Header;
import org.nrg.ecat.HeaderModification;
import org.nrg.ecat.var.AbstractVariable;
import org.nrg.ecat.var.ShortVariable;
import org.nrg.ecat.var.Variable;

public final class ShortListVariable
extends AbstractVariable {
    private final Variable shortVar;
    private final int length;

    public ShortListVariable(Header.Type type, String name, int offset, int length) {
        super(type, name, offset);
        this.shortVar = new ShortVariable(type, name + " component", offset);
        this.length = length;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        return sb.append("(").append(this.length).append(") Integer*2").toString();
    }

    @Override
    public Object readValue(InputStream in) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>(this.length);
        for (int i = 0; i < this.length; ++i) {
            list.add(this.shortVar.readValue(in));
        }
        return list;
    }

    @Override
    public HeaderModification createClearModification() {
        return this.createClearModification(2 * this.length);
    }

    @Override
    public HeaderModification createValueModification(Object value) {
        throw new UnsupportedOperationException();
    }
}

