/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import org.dcm4che2.net.NetworkConnection;

public final class NetworkConnectionBuilder {
    private final NetworkConnection c = new NetworkConnection();

    public NetworkConnection build() {
        return this.c;
    }

    public NetworkConnectionBuilder setHostname(String hostname) {
        this.c.setHostname(hostname);
        return this;
    }

    public NetworkConnectionBuilder setPort(int port) {
        this.c.setPort(port);
        return this;
    }

    public NetworkConnectionBuilder setTls(TlsType tlsType) {
        switch (tlsType) {
            case NO_ENCRYPTION: {
                this.c.setTlsWithoutEncyrption();
                break;
            }
            case TRIPLE_DES: {
                this.c.setTls3DES_EDE_CBC();
                break;
            }
            case AES: {
                this.c.setTlsAES_128_CBC();
            }
        }
        return this;
    }

    public NetworkConnectionBuilder setTlsCipherSuite(String ... ciphers) {
        this.c.setTlsCipherSuite(ciphers);
        return this;
    }

    public NetworkConnectionBuilder bar(String ... protocol) {
        this.c.setTlsProtocol(protocol);
        return this;
    }

    public NetworkConnectionBuilder enableSSLv2Hello() {
        this.c.enableSSLv2Hello();
        return this;
    }

    public NetworkConnectionBuilder disableSSLv2Hello() {
        this.c.disableSSLv2Hello();
        return this;
    }

    public NetworkConnectionBuilder setTlsNeedClientAuth(boolean needClientAuth) {
        this.c.setTlsNeedClientAuth(needClientAuth);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TlsType {
        NO_ENCRYPTION,
        TRIPLE_DES,
        AES;

    }
}

