/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import org.dcm4che2.data.DicomObject;
import org.dcm4che2.net.Association;
import org.nrg.dcm.DimseRSPStatusHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CStoreRSPHandler
extends DimseRSPStatusHandler {
    public void onDimseRSP(Association as, DicomObject cmd, DicomObject data) {
        int status = cmd.getInt(2304);
        switch (status) {
            case 0: {
                this.setSuccess();
                return;
            }
            case 45056: {
                this.setWarning(status, "Coercion of Data Elements", cmd.getString(2306));
                return;
            }
            case 45063: {
                this.setWarning(status, "Data Set does not match SOP Class", cmd.getString(2306));
                return;
            }
            case 45062: {
                this.setWarning(status, "Elements Discarded", cmd.getString(2306));
                return;
            }
        }
        if (42752 == (status & 0xFF00)) {
            this.setFailure(status, "Out of Resources", cmd.getString(2306));
            return;
        }
        if (43264 == (status & 0xFF00)) {
            this.setFailure(status, "Data Set does not match SOP class", cmd.getString(2306));
            return;
        }
        if (49152 == (status & 0xF000)) {
            this.setFailure(status, "Cannot understand", cmd.getString(2306));
            return;
        }
        Logger logger = LoggerFactory.getLogger(CStoreRSPHandler.class);
        logger.error(String.format("Unexpected RSP status %1$04x: %2s", status, cmd.getString(2306)));
        this.setFailure(status, "Noncompliant DIMSE error", cmd.getString(2306));
    }
}

