/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import java.io.File;
import java.io.IOException;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.dcm4che2.media.ApplicationProfile;
import org.dcm4che2.media.DicomDirReader;
import org.dcm4che2.media.DicomDirWriter;
import org.dcm4che2.media.FileSetInformation;
import org.dcm4che2.media.StdGenJPEGApplicationProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomDir {
    private final File file;
    private DicomDirReader dicomdir;
    private FileSetInformation fsinfo;
    private ApplicationProfile ap = new StdGenJPEGApplicationProfile();
    private boolean checkDuplicate = false;
    private final Logger logger = LoggerFactory.getLogger(DicomDir.class);

    public DicomDir(File file) throws IOException {
        this.file = file.getCanonicalFile();
    }

    private DicomDirWriter writer() {
        return (DicomDirWriter)this.dicomdir;
    }

    public final void fsinfo(FileSetInformation fsinfo) {
        BasicDicomObject dest = new BasicDicomObject();
        fsinfo.getDicomObject().copyTo((DicomObject)dest);
        this.fsinfo = new FileSetInformation((DicomObject)dest);
    }

    public FileSetInformation fsinfo() {
        if (this.fsinfo == null) {
            this.fsinfo = new FileSetInformation();
            this.fsinfo.init();
        }
        return this.fsinfo;
    }

    public void create() throws IOException {
        this.dicomdir = new DicomDirWriter(this.file, this.fsinfo());
    }

    public int purge() throws IOException {
        return this.writer().purge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addFile(File f) throws IOException {
        if ((f = f.getCanonicalFile()).equals(this.file)) {
            return 0;
        }
        int n = 0;
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                n += this.addFile(fs[i]);
            }
            return n;
        }
        DicomInputStream in = new DicomInputStream(f);
        boolean successful = false;
        try {
            String iuid;
            in.setHandler((DicomInputHandler)new StopTagInputHandler(2145386512));
            DicomObject dcmobj = in.readDicomObject();
            if (dcmobj.getString(131075) == null) {
                dcmobj.putString(131075, VR.UI, dcmobj.getString(524312));
            }
            if (dcmobj.getString(131074) == null) {
                dcmobj.putString(131074, VR.UI, dcmobj.getString(524310));
            }
            DicomObject patrec = this.ap.makePatientDirectoryRecord(dcmobj);
            DicomObject styrec = this.ap.makeStudyDirectoryRecord(dcmobj);
            DicomObject serrec = this.ap.makeSeriesDirectoryRecord(dcmobj);
            DicomObject instrec = this.ap.makeInstanceDirectoryRecord(dcmobj, this.dicomdir.toFileID(f));
            DicomObject rec = this.writer().addPatientRecord(patrec);
            if (rec == patrec) {
                ++n;
            }
            if ((rec = this.writer().addStudyRecord(rec, styrec)) == styrec) {
                ++n;
            }
            if ((rec = this.writer().addSeriesRecord(rec, serrec)) == serrec) {
                ++n;
            }
            if (n == 0 && this.checkDuplicate && this.dicomdir.findInstanceRecord(rec, iuid = dcmobj.getString(131075)) != null) {
                int n2 = 0;
                return n2;
            }
            this.writer().addChildRecord(rec, instrec);
            successful = true;
            int n3 = n + 1;
            return n3;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                if (successful) {
                    throw e;
                }
                this.logger.error("Unable to add file to DICOMDIR", (Throwable)e);
            }
        }
    }

    public void close() throws IOException {
        this.dicomdir.close();
    }
}

