/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import org.dcm4che2.data.DicomObject;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.DimseRSPHandler;

public abstract class DimseRSPStatusHandler
extends DimseRSPHandler {
    private ServiceStatus status = null;
    private int statusCode;
    private String meaning = null;
    private String comment = null;

    public abstract void onDimseRSP(Association var1, DicomObject var2, DicomObject var3);

    private void setFields(ServiceStatus status, int statusCode, String meaning, String comment) {
        if (null == status) {
            throw new IllegalStateException("already set: " + (Object)((Object)this));
        }
        this.status = status;
        this.statusCode = statusCode;
        this.meaning = meaning;
        this.comment = comment;
    }

    public final void setSuccess() {
        this.setFields(ServiceStatus.SUCCESS, 0, "Success", null);
    }

    public final void setWarning(int code, String meaning, String comment) {
        this.setFields(ServiceStatus.WARNING, code, meaning, comment);
    }

    public final void setFailure(int code, String meaning, String comment) {
        this.setFields(ServiceStatus.FAILURE, code, meaning, comment);
    }

    private final void assertStatus() {
        if (null == this.status) {
            throw new IllegalStateException("status not set");
        }
    }

    public final ServiceStatus getStatus() {
        this.assertStatus();
        return this.status;
    }

    public final int getStatusCode() {
        this.assertStatus();
        return this.statusCode;
    }

    public final String getStatusMeaning() {
        this.assertStatus();
        return this.meaning;
    }

    public final String getErrorComment() {
        this.assertStatus();
        return this.comment;
    }

    public String toString() {
        if (null == this.status) {
            return super.toString() + " (unset)";
        }
        StringBuilder sb = new StringBuilder(this.status.toString());
        sb.append(" ").append(Integer.toHexString(this.statusCode));
        sb.append(" ").append(this.meaning);
        if (null != this.comment) {
            sb.append(": ").append(this.comment);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServiceStatus {
        SUCCESS,
        WARNING,
        FAILURE;

    }
}

