/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import java.io.Serializable;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UID
implements Serializable,
Comparable<UID> {
    private static final long serialVersionUID = 1L;
    private static final int MAX_LEN = 64;
    private static final Pattern P = Pattern.compile("([1-9][0-9]*)?[0-9](\\.([1-9][0-9]*)?[0-9])+");
    private final String uid;

    public UID(String uid) throws InvalidUIDException {
        this.uid = uid;
        this.check(this.uid);
    }

    private void check(String uid) throws InvalidUIDException {
        if (null == uid || !P.matcher(uid).matches() || uid.length() > 64) {
            throw new InvalidUIDException(uid);
        }
    }

    @Override
    public int compareTo(UID o) {
        return this.uid.compareTo(o.uid);
    }

    public boolean equals(Object o) {
        return o instanceof UID && this.uid.equals(((UID)o).uid);
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public String toString() {
        return this.uid;
    }

    public static final class InvalidUIDException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private InvalidUIDException(String uid) {
            super(uid + " is not a valid UID");
        }
    }
}

