/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.io;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.StopTagInputHandler;
import org.nrg.dcm.DicomUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DicomFileObjectIterator
implements Iterator<Map.Entry<File, DicomObject>> {
    private final Iterator<File> files;
    private DicomInputHandler inputHandler = null;
    File nextFile = null;
    File lastFile = null;
    DicomObject nextObject = null;

    public DicomFileObjectIterator(Iterator<File> files) {
        this.files = files;
    }

    public DicomFileObjectIterator(Iterable<File> files) {
        this(files.iterator());
    }

    public DicomFileObjectIterator setInputHandler(DicomInputHandler handler) {
        this.inputHandler = handler;
        return this;
    }

    public DicomFileObjectIterator setStopTag(int stopTag) {
        return this.setInputHandler((DicomInputHandler)new StopTagInputHandler(stopTag));
    }

    @Override
    public boolean hasNext() {
        while (null == this.nextFile) {
            if (this.files.hasNext()) {
                File f = this.files.next();
                try {
                    this.nextObject = DicomUtils.read(f, this.inputHandler);
                    this.nextFile = f;
                    return true;
                }
                catch (IOException skip) {
                    continue;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public synchronized Map.Entry<File, DicomObject> next() {
        File currentFile = this.lastFile;
        this.lastFile = this.nextFile;
        if (this.hasNext()) {
            this.lastFile = this.nextFile;
            final File f = this.nextFile;
            final DicomObject o = this.nextObject;
            this.nextFile = null;
            this.nextObject = null;
            return new Map.Entry<File, DicomObject>(){

                @Override
                public File getKey() {
                    return f;
                }

                @Override
                public DicomObject getValue() {
                    return o;
                }

                @Override
                public DicomObject setValue(DicomObject value) {
                    throw new UnsupportedOperationException("cannot set DICOM object value");
                }
            };
        }
        this.lastFile = currentFile;
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (null == this.lastFile) {
            throw new IllegalStateException("no current file to delete");
        }
        this.lastFile.delete();
    }
}

