/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import com.google.common.base.Strings;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.util.TagUtils;
import org.nrg.dcm.Extractor;
import org.nrg.util.SortedSets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchedPatternExtractor
implements Extractor {
    private final Logger logger = LoggerFactory.getLogger(MatchedPatternExtractor.class);
    private final int tag;
    private final int group;
    private final Pattern pattern;

    public MatchedPatternExtractor(int tag, Pattern pattern, int group) {
        this.tag = tag;
        this.pattern = pattern;
        this.group = group;
    }

    @Override
    public String extract(DicomObject o) {
        String v = o.getString(this.tag);
        if (Strings.isNullOrEmpty((String)v)) {
            this.logger.trace("no match to {}: null or empty tag", (Object)this);
            return null;
        }
        Matcher m = this.pattern.matcher(v);
        if (m.matches()) {
            this.logger.trace("input {} matched rule {}", (Object)v, (Object)this);
            return m.group(this.group);
        }
        this.logger.trace("input {} did not match rule {}", (Object)v, (Object)this);
        return null;
    }

    @Override
    public SortedSet<Integer> getTags() {
        return SortedSets.singleton((Object)this.tag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(":").append(TagUtils.toString((int)this.tag)).append("~");
        sb.append(this.pattern).append("[").append(this.group).append("]");
        return sb.toString();
    }
}

