/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Iterators {
    private Iterators() {
    }

    static <T> Iterator<T> emptyIterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new IllegalStateException();
            }
        };
    }

    static <T> Iterator<T> of(final T t) {
        return new Iterator<T>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return t;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static <T> Iterator<T> of(final T ... ts) {
        return new Iterator<T>(){
            private int i = -1;

            @Override
            public boolean hasNext() {
                return this.i < ts.length - 1;
            }

            @Override
            public T next() {
                if (++this.i < ts.length) {
                    return ts[this.i];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

