/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import org.nrg.util.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SortedSets {
    private static final String IMMUTABLE_MESSAGE = "cannot modify immutable set";

    private SortedSets() {
    }

    public static <T> SortedSet<T> empty() {
        return new SortedSet<T>(){

            @Override
            public Comparator<? super T> comparator() {
                return null;
            }

            @Override
            public T first() {
                throw new NoSuchElementException();
            }

            @Override
            public SortedSet<T> headSet(T toElement) {
                return this;
            }

            @Override
            public T last() {
                throw new NoSuchElementException();
            }

            @Override
            public SortedSet<T> subSet(T fromElement, T toElement) {
                return this;
            }

            @Override
            public SortedSet<T> tailSet(T fromElement) {
                return this;
            }

            @Override
            public boolean add(T e) {
                throw new UnsupportedOperationException(SortedSets.IMMUTABLE_MESSAGE);
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                throw new UnsupportedOperationException(SortedSets.IMMUTABLE_MESSAGE);
            }

            @Override
            public void clear() {
            }

            @Override
            public boolean contains(Object o) {
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return c.isEmpty();
            }

            @Override
            public boolean equals(Object o) {
                return o instanceof Set && ((Set)o).isEmpty();
            }

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public Iterator<T> iterator() {
                return Iterators.emptyIterator();
            }

            @Override
            public boolean remove(Object o) {
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return false;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return false;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public Object[] toArray() {
                return new Object[0];
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return (Object[])Array.newInstance(a.getClass(), 0);
            }
        };
    }

    public static <T> SortedSet<T> singleton(final T t, final Comparator<? super T> comparator) {
        return new SortedSet<T>(){

            @Override
            public Comparator<? super T> comparator() {
                return comparator;
            }

            private int compareTo(T other) {
                if (null == comparator) {
                    return ((Comparable)t).compareTo(other);
                }
                return comparator.compare(t, other);
            }

            @Override
            public T first() {
                return t;
            }

            @Override
            public SortedSet<T> headSet(T toElement) {
                if (this.compareTo(toElement) < 0) {
                    return this;
                }
                return SortedSets.empty();
            }

            @Override
            public T last() {
                return t;
            }

            @Override
            public SortedSet<T> subSet(T fromElement, T toElement) {
                if (this.compareTo(fromElement) >= 0 && this.compareTo(toElement) < 0) {
                    return this;
                }
                return SortedSets.empty();
            }

            @Override
            public SortedSet<T> tailSet(T fromElement) {
                if (this.compareTo(fromElement) >= 0) {
                    return this;
                }
                return SortedSets.empty();
            }

            @Override
            public boolean add(T e) {
                throw new UnsupportedOperationException(SortedSets.IMMUTABLE_MESSAGE);
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                throw new UnsupportedOperationException(SortedSets.IMMUTABLE_MESSAGE);
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException(SortedSets.IMMUTABLE_MESSAGE);
            }

            @Override
            public boolean contains(Object o) {
                return t.equals(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object o : c) {
                    if (t.equals(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean equals(Object o) {
                if (o instanceof Set) {
                    Set s = (Set)o;
                    return 1 == s.size() && s.contains(t);
                }
                return false;
            }

            @Override
            public int hashCode() {
                return null == t ? 0 : t.hashCode();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Iterator<T> iterator() {
                return Iterators.of(t);
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException(SortedSets.IMMUTABLE_MESSAGE);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException(SortedSets.IMMUTABLE_MESSAGE);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException(SortedSets.IMMUTABLE_MESSAGE);
            }

            @Override
            public int size() {
                return 1;
            }

            @Override
            public Object[] toArray() {
                return new Object[]{t};
            }

            @Override
            public <T> T[] toArray(T[] a) {
                Object[] ts = (Object[])Array.newInstance(t.getClass(), 1);
                ts[0] = t;
                return ts;
            }
        };
    }

    public static <T> SortedSet<T> singleton(T t) {
        return SortedSets.singleton(t, null);
    }
}

