/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.ScriptFunction;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIndexedLabelFunction
implements ScriptFunction {
    protected abstract boolean isAvailable(String var1) throws ScriptEvaluationException;

    private final Value getFormat(List<? extends Value> values) throws ScriptEvaluationException {
        try {
            return values.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            try {
                throw new ScriptEvaluationException(this.getClass().getField("name").get(null) + " requires format argument");
            }
            catch (IllegalArgumentException e1) {
                throw new RuntimeException(e1);
            }
            catch (SecurityException e1) {
                throw new RuntimeException(e1);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException(e1);
            }
            catch (NoSuchFieldException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    @Override
    public Value apply(List<? extends Value> args) throws ScriptEvaluationException {
        final Value format = this.getFormat(args);
        return new Value(){

            private NumberFormat buildFormatter(int len) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < len; ++i) {
                    sb.append("0");
                }
                return new DecimalFormat(sb.toString());
            }

            private String valueFor(String format2) throws ScriptEvaluationException {
                int end;
                int offset = format2.indexOf(35);
                if (-1 == offset) {
                    return "";
                }
                for (end = offset; end < format2.length() && '#' == format2.charAt(end); ++end) {
                }
                NumberFormat nf = this.buildFormatter(end - offset);
                StringBuffer sb = new StringBuffer(format2);
                int i = 0;
                String label;
                while (!AbstractIndexedLabelFunction.this.isAvailable(label = sb.replace(offset, end, nf.format(i)).toString())) {
                    ++i;
                }
                return label;
            }

            @Override
            public String on(Map<Integer, String> m) throws ScriptEvaluationException {
                return this.valueFor(format.on(m));
            }

            @Override
            public String on(DicomObject o) throws ScriptEvaluationException {
                return this.valueFor(format.on(o));
            }

            @Override
            public void replace(Variable v) {
                format.replace(v);
            }

            @Override
            public Set<Variable> getVariables() {
                return format.getVariables();
            }

            @Override
            public SortedSet<Long> getTags() {
                return format.getTags();
            }
        };
    }
}

