/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.collect.ImmutableSortedSet;
import java.util.SortedSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.ConstraintMatch;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractValueConstraint
implements ConstraintMatch {
    private final Value left;
    private final Value right;

    AbstractValueConstraint(Value left, Value right) {
        this.left = left;
        this.right = right;
    }

    protected abstract boolean matches(String var1, String var2) throws ScriptEvaluationException;

    @Override
    public SortedSet<Long> getTags() {
        ImmutableSortedSet.Builder tags = ImmutableSortedSet.naturalOrder();
        tags.addAll(this.left.getTags());
        tags.addAll(this.right.getTags());
        return tags.build();
    }

    @Override
    public final boolean matches(DicomObject o) throws ScriptEvaluationException {
        return this.matches(this.left.on(o), this.right.on(o));
    }

    public String toString(String operation) {
        return "Constraint: " + this.left + " " + operation + " " + this.right;
    }
}

