/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.TagUtils;
import org.nrg.dcm.edit.AbstractOperation;
import org.nrg.dcm.edit.Action;
import org.nrg.dcm.edit.ConstantValue;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.TagPattern;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assignment
extends AbstractOperation {
    private final Logger logger = LoggerFactory.getLogger(Assignment.class);
    private final TagPattern pattern;
    private final Value value;

    public Assignment(TagPattern tagpat, Value value) {
        super("Assign");
        this.pattern = tagpat;
        this.value = value;
    }

    public Assignment(int tag, Value value) {
        this(new TagPattern(tag), value);
    }

    public Assignment(Integer tag, Value value) {
        this((int)tag, value);
    }

    public Assignment(int tag, String svalue) {
        this(tag, (Value)new ConstantValue(svalue));
    }

    @Override
    public boolean affects(int tag) {
        return this.pattern.apply(tag);
    }

    @Override
    public long getTopTag() {
        TreeSet tags = Sets.newTreeSet(this.value.getTags());
        tags.add(this.pattern.getTopTag());
        return (Long)tags.last();
    }

    public boolean equals(Object o) {
        if (o instanceof Assignment) {
            Assignment oa = (Assignment)o;
            return this.pattern.equals(oa.pattern) && this.value.equals(oa.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pattern, this.value});
    }

    @Override
    public Action makeAction(final DicomObject o) throws ScriptEvaluationException {
        final String v = this.value.on(o);
        return new Action(){

            public void apply() throws ScriptEvaluationException {
                for (long ltag : Assignment.this.pattern.apply(o)) {
                    int tag = (int)ltag;
                    VR vr = o.vrOf(tag);
                    if (VR.UN.equals(vr)) {
                        Assignment.this.logger.debug("VR for {} is UN; writing as LO instead", (Object)TagUtils.toString((int)tag));
                        vr = VR.LO;
                    }
                    try {
                        o.putString(new int[]{tag}, vr, v);
                    }
                    catch (UnsupportedOperationException e) {
                        throw new ScriptEvaluationException("Unable to set attribute " + TagUtils.toString((int)tag) + " (VR " + vr + ") to \"" + v + "\"", e);
                    }
                }
            }

            public String toString() {
                return MessageFormat.format("{0}: {1} := {2}", Assignment.this.getName(), Assignment.this.pattern, v);
            }
        };
    }

    @Override
    public void replace(Variable v) {
        this.value.replace(v);
    }

    @Override
    public String apply(Map<Integer, String> vals) throws ScriptEvaluationException {
        return this.value.on(vals);
    }

    public String toString() {
        String v;
        StringBuffer sb = new StringBuffer(this.getName());
        sb.append(" ");
        sb.append(this.pattern);
        try {
            v = this.value.on(new HashMap<Integer, String>());
        }
        catch (ScriptEvaluationException e) {
            v = this.value.toString();
        }
        sb.append(" := ").append(v);
        return sb.toString();
    }
}

