/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.ConstraintMatch;
import org.nrg.dcm.edit.ScriptEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constraint {
    private static final Iterable<File> empty = Collections.emptyList();
    private final ConstraintMatch m;
    private final Set<File> files;

    public Constraint(ConstraintMatch m) {
        this(m, empty);
    }

    public Constraint(ConstraintMatch m, File f) {
        this(m, Collections.singletonList(f));
    }

    public Constraint(ConstraintMatch m, Iterable<File> fs) {
        this.m = m;
        this.files = Sets.newHashSet(fs);
        if (null == m && this.files.isEmpty()) {
            throw new IllegalArgumentException("Either value constraint or file list must be provided");
        }
    }

    boolean matches(File f, DicomObject o) throws ScriptEvaluationException {
        assert (this.m != null || !this.files.isEmpty());
        if (this.m != null && !this.m.matches(o)) {
            return false;
        }
        return this.files.isEmpty() || this.files.contains(f);
    }

    public SortedSet<Long> getTags() {
        return this.m.getTags();
    }

    public String toString() {
        return this.m.toString();
    }
}

