/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.util.TagUtils;

public final class DicomTableEntry {
    private final String header;
    private final String level;
    private final int tag;
    private final boolean isSubstitution;

    public DicomTableEntry(int tag, String level, boolean isSubstitution, String header) {
        this.tag = tag;
        this.level = level;
        this.isSubstitution = isSubstitution;
        this.header = null == header ? new BasicDicomObject().nameOf(tag) : header;
    }

    public DicomTableEntry(int tag, String level) {
        this(tag, level, false, null);
    }

    public int getTag() {
        return this.tag;
    }

    public String getLevel() {
        return this.level;
    }

    public String getHeader() {
        return this.header;
    }

    public boolean isSubstitution() {
        return this.isSubstitution;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DicomTableEntry)) {
            return false;
        }
        DicomTableEntry other = (DicomTableEntry)o;
        return this.tag == other.tag && this.isSubstitution == other.isSubstitution && this.header.equals(other.header) && this.level.equals(other.level);
    }

    public int hashCode() {
        assert (this.header != null);
        int result = 17;
        result = 37 * result + this.header.hashCode();
        result = 37 * result + this.level.hashCode();
        result = 37 * result + this.tag;
        result = 37 * result + (this.isSubstitution ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(TagUtils.toString((int)this.tag));
        sb.append(" (");
        sb.append(this.header);
        sb.append(") ");
        sb.append(":");
        sb.append(this.level);
        if (this.isSubstitution) {
            sb.append(" - substitution");
        }
        return sb.toString();
    }
}

