/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import java.util.Map;
import java.util.SortedSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.Action;
import org.nrg.dcm.edit.ConstantValue;
import org.nrg.dcm.edit.Operation;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Echo
implements Operation {
    private final Value v;

    public Echo(String message) {
        this(new ConstantValue(message));
    }

    public Echo(Value v) {
        this.v = v;
    }

    @Override
    public boolean affects(int _) {
        return false;
    }

    @Override
    public Action makeAction(DicomObject o) {
        String m;
        try {
            m = this.v.on(o);
        }
        catch (ScriptEvaluationException e) {
            m = "[uninterpretable: " + this.v + "]";
        }
        final String message = m;
        return new Action(){

            public void apply() {
                System.out.print(message);
            }

            public String toString() {
                return Echo.this.getName() + ": " + message;
            }
        };
    }

    @Override
    public long getTopTag() {
        SortedSet<Long> tags = this.v.getTags();
        return tags.isEmpty() ? 0L : tags.last();
    }

    @Override
    public String apply(Map<Integer, String> vals) {
        String m;
        try {
            m = this.v.on(vals);
        }
        catch (ScriptEvaluationException e) {
            m = "[uninterpretable: " + this.v + "]";
        }
        System.out.print(m);
        return null;
    }

    @Override
    public void replace(Variable var) {
        this.v.replace(var);
    }

    public String toString() {
        return this.v.toString();
    }

    @Override
    public String getName() {
        return "Echo";
    }
}

