/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.ValueGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneratorScope {
    private final Logger logger = LoggerFactory.getLogger(GeneratorScope.class);
    private final Map<String, GeneratorCache> maps = Maps.newHashMap();

    public void setGenerator(String label, ValueGenerator generator) {
        this.maps.put(label, new TagCache(generator));
    }

    public String getValue(String label, int tag, String old, Iterable<String> values) throws ScriptEvaluationException {
        this.logger.trace("generating value for {} {}", (Object)label, values);
        if (!this.maps.containsKey(label)) {
            throw new ScriptEvaluationException("undefined generator " + label);
        }
        return this.maps.get(label).getValue(tag, values, old);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface GeneratorCache {
        public String getValue(int var1, Iterable<String> var2, String var3) throws ScriptEvaluationException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TagCache
    implements GeneratorCache {
        private final Map<Integer, Map<String, String>> attrs = Maps.newHashMap();
        private final ValueGenerator generator;

        TagCache(ValueGenerator generator) {
            this.generator = generator;
        }

        @Override
        public String getValue(int tag, Iterable<String> params, String old) throws ScriptEvaluationException {
            Map<String, String> valueMap;
            String v;
            Integer key = new Integer(tag);
            if (!this.attrs.containsKey(key)) {
                this.attrs.put(key, new HashMap());
            }
            if (null == (v = (valueMap = this.attrs.get(key)).get(old))) {
                String newv = this.generator.valueFor(old, params);
                valueMap.put(old, newv);
                return newv;
            }
            return v;
        }
    }
}

