/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomOutputStream;
import org.nrg.dcm.DicomUtils;
import org.nrg.dcm.edit.Action;
import org.nrg.dcm.edit.AttributeException;
import org.nrg.dcm.edit.EditDCMLexer;
import org.nrg.dcm.edit.EditDCMParser;
import org.nrg.dcm.edit.EditDCMTreeParser;
import org.nrg.dcm.edit.Operation;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.ScriptFunction;
import org.nrg.dcm.edit.Statement;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.ValueGenerator;
import org.nrg.dcm.edit.Variable;
import org.nrg.dcm.edit.fn.Format;
import org.nrg.dcm.edit.fn.GetURL;
import org.nrg.dcm.edit.fn.HashUID;
import org.nrg.dcm.edit.fn.Lowercase;
import org.nrg.dcm.edit.fn.Match;
import org.nrg.dcm.edit.fn.Replace;
import org.nrg.dcm.edit.fn.Substring;
import org.nrg.dcm.edit.fn.Uppercase;
import org.nrg.dcm.edit.fn.UrlEncode;
import org.nrg.dcm.edit.gen.UIDGenerator;
import org.nrg.io.PresuffixFileMapper;
import org.nrg.util.GraphUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptApplicator {
    private final Logger logger = LoggerFactory.getLogger(ScriptApplicator.class);
    private final List<Statement> statements;
    private final EditDCMTreeParser astParser;

    public ScriptApplicator(InputStream script, Map<String, ScriptFunction> functions, Map<String, ValueGenerator> generators) throws IOException, ScriptEvaluationException {
        if (null == script) {
            this.statements = Collections.emptyList();
            this.astParser = null;
        } else {
            try {
                EditDCMLexer lexer = new EditDCMLexer((CharStream)new ANTLRInputStream(script));
                EditDCMParser parser = new EditDCMParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
                EditDCMParser.script_return sr = parser.script();
                this.logger.trace("parsing to AST");
                CommonTree ast = (CommonTree)sr.getTree();
                if (null == ast) {
                    this.logger.trace("unparseable");
                    this.astParser = null;
                    this.statements = Lists.newArrayList();
                } else {
                    this.astParser = new EditDCMTreeParser((TreeNodeStream)new CommonTreeNodeStream((Object)ast));
                    this.astParser.setFunction("substring", new Substring());
                    this.astParser.setFunction("format", new Format());
                    this.astParser.setFunction("lowercase", new Lowercase());
                    this.astParser.setFunction("uppercase", new Uppercase());
                    this.astParser.setFunction("getURL", new GetURL());
                    this.astParser.setFunction("replace", new Replace());
                    this.astParser.setFunction("match", new Match());
                    this.astParser.setFunction("urlEncode", new UrlEncode());
                    this.astParser.setFunction("hashUID", new HashUID());
                    for (Map.Entry<String, ScriptFunction> entry : functions.entrySet()) {
                        this.logger.trace("adding function {}", entry);
                        this.astParser.setFunction(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry<String, Object> entry : generators.entrySet()) {
                        this.logger.trace("adding generator {}", entry);
                        this.astParser.setGenerator(entry.getKey(), (ValueGenerator)entry.getValue());
                    }
                    if (!generators.containsKey("UID")) {
                        this.logger.trace("adding generator {}", (Object)"UID");
                        this.astParser.setGenerator("UID", new UIDGenerator());
                    }
                    this.logger.trace("ready to parse");
                    this.statements = this.astParser.script();
                    this.logger.trace("{}", this.statements);
                }
            }
            catch (RecognitionException e) {
                throw new ScriptEvaluationException("error parsing script", e);
            }
        }
    }

    public ScriptApplicator(InputStream script, Map<String, ScriptFunction> functions) throws IOException, ScriptEvaluationException {
        this(script, functions, new HashMap<String, ValueGenerator>());
    }

    public ScriptApplicator(InputStream script) throws IOException, ScriptEvaluationException {
        this(script, new HashMap<String, ScriptFunction>(), new HashMap<String, ValueGenerator>());
    }

    public ScriptApplicator() {
        this.statements = Collections.emptyList();
        this.astParser = null;
    }

    public int getTopTag() {
        TreeSet tags = Sets.newTreeSet();
        tags.add(0L);
        for (Statement s : this.statements) {
            tags.add(s.getTopTag());
        }
        return ((Long)tags.last()).intValue();
    }

    public Variable getVariable(String label) {
        return null == this.astParser ? null : this.astParser.getVariable(label);
    }

    public Map<String, Variable> getVariables() {
        return null == this.astParser ? Collections.emptyMap() : this.astParser.getVariables();
    }

    public List<Variable> getSortedVariables(Collection<String> excluding) {
        LinkedHashMap graph = Maps.newLinkedHashMap();
        for (Variable v : this.getVariables().values()) {
            if (excluding.contains(v.getName())) continue;
            Value iv = v.getInitialValue();
            ArrayList dependencies = Lists.newArrayList();
            if (null != iv) {
                for (Variable dv : iv.getVariables()) {
                    if (excluding.contains(dv.getName())) continue;
                    dependencies.add(dv);
                }
            }
            graph.put(v, dependencies);
        }
        for (Collection dependencies : graph.values()) {
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                if (graph.containsKey(i.next())) continue;
                i.remove();
            }
        }
        this.logger.trace("sorting variable dependencies: {}", (Object)graph);
        return GraphUtils.topologicalSort((Map)graph);
    }

    public List<Variable> getSortedVariables(String[] excluding) {
        return this.getSortedVariables(Arrays.asList(excluding));
    }

    public List<Variable> getSortedVariables() {
        return this.getSortedVariables(Collections.<String>emptyList());
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public DicomObject apply(File f, DicomObject o) throws AttributeException, ScriptEvaluationException {
        List<Action> actions = Statement.getActions(this.statements, f, o);
        Collections.reverse(actions);
        for (Action action : actions) {
            action.apply();
        }
        return o;
    }

    public DicomObject apply(File f) throws IOException, AttributeException, ScriptEvaluationException {
        return this.apply(f, DicomUtils.read((File)f));
    }

    public void setGenerator(String label, ValueGenerator generator) {
        if (null != this.astParser) {
            this.astParser.setGenerator(label, generator);
        }
    }

    public void setFunction(String label, ScriptFunction function) {
        if (null != this.astParser) {
            this.astParser.setFunction(label, function);
        }
    }

    public Variable unify(Variable v) {
        Variable vn = this.astParser.unify(v);
        for (Statement s : this.statements) {
            Operation o = s.getOperation();
            if (null == o) continue;
            o.replace(v);
        }
        return vn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ScriptApplicator applicator;
        InputStream in = 0 == args.length || "-".equals(args[0]) ? System.in : new FileInputStream(args[0]);
        try {
            applicator = new ScriptApplicator(in);
        }
        finally {
            in.close();
        }
        PresuffixFileMapper mapper = new PresuffixFileMapper("-mod");
        for (int i = 1; i < args.length; ++i) {
            File f = new File(args[i]);
            DicomOutputStream out = new DicomOutputStream((OutputStream)new FileOutputStream((File)mapper.apply(f)));
            try {
                out.writeDicomFile(applicator.apply(f));
                continue;
            }
            finally {
                out.close();
            }
        }
    }
}

