/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import org.nrg.dcm.edit.MultipleInitializationException;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptReferencedVariable
implements Variable {
    private final Logger logger = LoggerFactory.getLogger(ScriptReferencedVariable.class);
    private final String name;
    private String value = null;
    private Value initValue = null;
    private boolean isHidden = false;
    private String description = null;
    private String exportField = null;

    public ScriptReferencedVariable(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExportField() {
        return this.exportField;
    }

    public Value getInitialValue() {
        return this.initValue;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExportField(String exportField) {
        this.exportField = exportField;
    }

    public void setInitialValue(Value value) throws MultipleInitializationException {
        if (null != this.initValue) {
            throw new MultipleInitializationException(this, value);
        }
        this.initValue = value;
    }

    public void setIsHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public void setValue(String value) {
        this.logger.trace("set {} to {}", (Object)this, (Object)value);
        this.value = value;
    }

    public boolean equals(Object o) {
        return o instanceof Variable && this.name.equals(((Variable)o).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return new StringBuffer(super.toString()).append(" (").append(this.name).append(")").toString();
    }
}

