/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.collect.ImmutableSortedSet;
import java.util.SortedSet;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.StringUtils;
import org.dcm4che2.util.TagUtils;
import org.nrg.dcm.edit.ConstraintMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleConstraintMatch
implements ConstraintMatch {
    private final int tag;
    private final String pattern;

    SimpleConstraintMatch(int tag, String pattern) {
        this.tag = tag;
        this.pattern = pattern;
    }

    SimpleConstraintMatch(Integer tag, String pattern) {
        this((int)tag, pattern);
    }

    @Override
    public SortedSet<Long> getTags() {
        return ImmutableSortedSet.of((Comparable)Long.valueOf(0xFFFFFFFFL & (long)this.tag));
    }

    final String getPattern() {
        return this.pattern;
    }

    boolean matches(String value) {
        return value.equals(this.pattern);
    }

    @Override
    public boolean matches(DicomObject o) {
        if (o.contains(this.tag)) {
            VR vr = o.vrOf(this.tag);
            if (VR.SQ == vr) {
                throw new RuntimeException("can't use SQ type attribute for constraint");
            }
            String value = VR.UN == vr ? o.getString(this.tag) : StringUtils.join((String[])o.getStrings(this.tag), (char)'\\');
            return this.matches(value);
        }
        return false;
    }

    public String toString() {
        return "Constraint: " + TagUtils.toString((int)this.tag) + " matches " + this.pattern;
    }
}

