/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.ScriptEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagPattern
implements Function<DicomObject, Iterable<Long>> {
    public static final Character ANY_DIGIT = Character.valueOf('X');
    public static final Character EVEN_DIGIT = Character.valueOf('@');
    public static final Character ODD_DIGIT = Character.valueOf('#');
    public static final ImmutableSet<Character> HEX_DIGITS = ImmutableSet.of((Object)Character.valueOf('0'), (Object)Character.valueOf('1'), (Object)Character.valueOf('2'), (Object)Character.valueOf('3'), (Object)Character.valueOf('4'), (Object)Character.valueOf('5'), (Object[])new Character[]{Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('A'), Character.valueOf('b'), Character.valueOf('B'), Character.valueOf('c'), Character.valueOf('C'), Character.valueOf('d'), Character.valueOf('D'), Character.valueOf('e'), Character.valueOf('E'), Character.valueOf('f'), Character.valueOf('F')});
    private static final long MASK_ALL = 0xFFFFFFFFL;
    private static final long MAX_EVEN = 0xEEEEEEEEL;
    private static final long MAX_ODD = 0xFFFFFFFFL;
    private final String pattern;
    private final long exactMask;
    private final long anyMask;
    private final long evenMask;
    private final long oddMask;
    private final long exactPart;

    private static boolean matchesMod2(long v, long mask, int mod2) {
        while (mask != 0L) {
            if (0L != (mask & 0xFL) && (v & 0xFL) % 2L != (long)mod2) {
                return false;
            }
            v >>= 4;
            mask >>= 4;
        }
        return true;
    }

    public TagPattern(int exact) {
        this.exactMask = 0xFFFFFFFFL;
        this.oddMask = 0L;
        this.evenMask = 0L;
        this.anyMask = 0L;
        this.exactPart = exact;
        this.pattern = String.format("0x%08x", exact);
    }

    public TagPattern(String spec) throws ScriptEvaluationException {
        this.pattern = spec;
        if (9 != spec.length() || ',' != spec.charAt(4)) {
            throw new ScriptEvaluationException("tag must be of form gggg,eeee");
        }
        long exact = 0L;
        long any = 0L;
        long even = 0L;
        long odd = 0L;
        long exactPart = 0L;
        for (int i = 0; i < 9; ++i) {
            Character c = Character.valueOf(spec.charAt(i));
            if (c.equals(Character.valueOf(','))) {
                if (i == 4) continue;
                throw new ScriptEvaluationException("tag comma at unexpected position " + i);
            }
            exact <<= 4;
            any <<= 4;
            even <<= 4;
            odd <<= 4;
            exactPart <<= 4;
            if (HEX_DIGITS.contains((Object)c)) {
                exact |= 0xFL;
                exactPart |= (long)Integer.parseInt(String.valueOf(c), 16);
                continue;
            }
            if (ANY_DIGIT.equals(c)) {
                any |= 0xFL;
                continue;
            }
            if (ODD_DIGIT.equals(c)) {
                odd |= 0xFL;
                continue;
            }
            if (EVEN_DIGIT.equals(c)) {
                even |= 0xFL;
                continue;
            }
            throw new ScriptEvaluationException("unrecognized tag digit '" + c + "'");
        }
        assert ((exact | any | even | odd) == 0xFFFFFFFFL);
        assert ((exact & any) == 0L);
        assert ((exact & even) == 0L);
        assert ((exact & odd) == 0L);
        assert ((any & even) == 0L);
        assert ((any & odd) == 0L);
        assert ((even & odd) == 0L);
        this.exactMask = exact;
        this.anyMask = any;
        this.evenMask = even;
        this.oddMask = odd;
        this.exactPart = exactPart;
    }

    public Iterable<Long> apply(DicomObject o) {
        ArrayList tags = Lists.newArrayList();
        Iterator ei = o.datasetIterator();
        while (ei.hasNext()) {
            Integer tag = ((DicomElement)ei.next()).tag();
            if (!this.apply(tag)) continue;
            tags.add(0xFFFFFFFFL & (long)tag.intValue());
        }
        if (this.exactMask == 0xFFFFFFFFL && !tags.contains(this.exactPart)) {
            tags.add(this.exactPart);
        }
        return tags;
    }

    public boolean apply(Integer tag) {
        if (null == tag) {
            return false;
        }
        long t = (long)tag.intValue() & 0xFFFFFFFFL;
        return (t & this.exactMask) == this.exactPart && TagPattern.matchesMod2(t, this.evenMask, 0) && TagPattern.matchesMod2(t, this.oddMask, 1);
    }

    public long getTopTag() {
        return this.exactPart | this.evenMask & 0xEEEEEEEEL | (this.oddMask | this.anyMask) & 0xFFFFFFFFL;
    }

    public String toString() {
        return "TagPattern " + this.pattern;
    }
}

