/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit.fn;

import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.ScriptFunction;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;
import org.nrg.util.HttpClient;
import org.nrg.util.IHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetURL
implements ScriptFunction {
    public static final String name = "getURL";

    @Override
    public Value apply(List<? extends Value> args) throws ScriptEvaluationException {
        final Value url = args.get(0);
        return new Value(){

            @Override
            public Set<Variable> getVariables() {
                return Collections.emptySet();
            }

            @Override
            public SortedSet<Long> getTags() {
                return ImmutableSortedSet.of();
            }

            @Override
            public String on(DicomObject o) throws ScriptEvaluationException {
                return GetURL.this.request(url.on(o));
            }

            @Override
            public String on(Map<Integer, String> m) throws ScriptEvaluationException {
                return GetURL.this.request(url.on(m));
            }

            @Override
            public void replace(Variable v) {
                url.replace(v);
            }
        };
    }

    private String request(String url) throws ScriptEvaluationException {
        try {
            String response = this.getHttpClient().request(new URL(url));
            if (response == null) {
                throw new ScriptEvaluationException("Empty response from external webservice, " + url);
            }
            return response.trim();
        }
        catch (MalformedURLException e) {
            throw new ScriptEvaluationException("Improper URL, " + url);
        }
        catch (IOException e) {
            throw new ScriptEvaluationException("Error connecting to external webservice, " + url, e);
        }
    }

    protected IHttpClient getHttpClient() {
        return new HttpClient();
    }
}

