/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm.edit.fn;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.edit.IntegerValue;
import org.nrg.dcm.edit.ScriptEvaluationException;
import org.nrg.dcm.edit.ScriptFunction;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Match
implements ScriptFunction {
    public static final String name = "match";

    @Override
    public Value apply(List<? extends Value> args) throws ScriptEvaluationException {
        final Value value = args.get(0);
        final Value pattern = args.get(1);
        final int group = ((IntegerValue)args.get(2)).getValue();
        return new Value(){

            @Override
            public Set<Variable> getVariables() {
                LinkedHashSet vs = Sets.newLinkedHashSet(value.getVariables());
                vs.addAll(pattern.getVariables());
                return vs;
            }

            @Override
            public SortedSet<Long> getTags() {
                TreeSet ts = Sets.newTreeSet(value.getTags());
                ts.addAll(pattern.getTags());
                return ts;
            }

            @Override
            public String on(DicomObject o) throws ScriptEvaluationException {
                return Match.evaluate(value.on(o), pattern.on(o), group);
            }

            @Override
            public String on(Map<Integer, String> m) throws ScriptEvaluationException {
                return Match.evaluate(value.on(m), pattern.on(m), group);
            }

            @Override
            public void replace(Variable var) {
                value.replace(var);
                pattern.replace(var);
            }
        };
    }

    private static String evaluate(String value, String pattern, int group) {
        if (null == value) {
            return null;
        }
        Matcher m = Pattern.compile(pattern).matcher(value);
        return m.matches() ? m.group(group) : null;
    }
}

